/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.CachedDNSToSwitchMapping;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.zookeeper.ZkBookieRackAffinityMapping;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BookKeeperClientFactoryImplTest {
    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareDisabled() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        Assert.assertNull((Object)bkConf.getProperty("minNumRacksPerWriteQuorum"));
        Assert.assertNull((Object)bkConf.getProperty("enforceMinNumRacksPerWriteQuorum"));
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)ZkBookieRackAffinityMapping.class.getName());
        Assert.assertFalse((boolean)bkConf.getEnforceMinNumRacksPerWriteQuorum());
        Assert.assertEquals((int)2, (int)bkConf.getMinNumRacksPerWriteQuorum());
        ((ZooKeeperCache)bkConf.getProperty("zk_cache_instance")).stop();
    }

    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareEnabled() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        Assert.assertNull((Object)bkConf.getProperty("minNumRacksPerWriteQuorum"));
        Assert.assertNull((Object)bkConf.getProperty("enforceMinNumRacksPerWriteQuorum"));
        conf.setBookkeeperClientRegionawarePolicyEnabled(true);
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertTrue((boolean)bkConf.getBoolean("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getString("reppRegionsToWrite"));
        Assert.assertEquals((int)2, (int)bkConf.getInt("reppMinimumRegionsForDurability"));
        Assert.assertTrue((boolean)bkConf.getBoolean("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)ZkBookieRackAffinityMapping.class.getName());
        Assert.assertFalse((boolean)bkConf.getEnforceMinNumRacksPerWriteQuorum());
        Assert.assertEquals((int)2, (int)bkConf.getMinNumRacksPerWriteQuorum());
        ((ZooKeeperCache)bkConf.getProperty("zk_cache_instance")).stop();
    }

    @Test
    public void testSetDefaultEnsemblePlacementPolicyRackAwareEnabledChangedValues() {
        AtomicReference rackawarePolicyZkCache = new AtomicReference();
        AtomicReference clientIsolationZkCache = new AtomicReference();
        ClientConfiguration bkConf = new ClientConfiguration();
        ServiceConfiguration conf = new ServiceConfiguration();
        ZooKeeper zkClient = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Assert.assertNull((Object)bkConf.getProperty("reppEnableValidation"));
        Assert.assertNull((Object)bkConf.getProperty("reppRegionsToWrite"));
        Assert.assertNull((Object)bkConf.getProperty("reppMinimumRegionsForDurability"));
        Assert.assertNull((Object)bkConf.getProperty("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertNull((Object)bkConf.getProperty("reppDnsResolverClass"));
        Assert.assertNull((Object)bkConf.getProperty("minNumRacksPerWriteQuorum"));
        Assert.assertNull((Object)bkConf.getProperty("enforceMinNumRacksPerWriteQuorum"));
        conf.setBookkeeperClientRegionawarePolicyEnabled(true);
        conf.getProperties().setProperty("reppEnableValidation", "false");
        conf.getProperties().setProperty("reppRegionsToWrite", "region1;region2");
        conf.getProperties().setProperty("reppMinimumRegionsForDurability", "4");
        conf.getProperties().setProperty("reppEnableDurabilityEnforcementInReplace", "false");
        conf.getProperties().setProperty("reppDnsResolverClass", CachedDNSToSwitchMapping.class.getName());
        conf.setBookkeeperClientMinNumRacksPerWriteQuorum(20);
        conf.setBookkeeperClientEnforceMinNumRacksPerWriteQuorum(true);
        BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(rackawarePolicyZkCache, clientIsolationZkCache, (ClientConfiguration)bkConf, (ServiceConfiguration)conf, (ZooKeeper)zkClient);
        Assert.assertFalse((boolean)bkConf.getBoolean("reppEnableValidation"));
        Assert.assertEquals((String)"region1;region2", (String)bkConf.getString("reppRegionsToWrite"));
        Assert.assertEquals((int)4, (int)bkConf.getInt("reppMinimumRegionsForDurability"));
        Assert.assertFalse((boolean)bkConf.getBoolean("reppEnableDurabilityEnforcementInReplace"));
        Assert.assertEquals((Object)bkConf.getProperty("reppDnsResolverClass"), (Object)CachedDNSToSwitchMapping.class.getName());
        Assert.assertTrue((boolean)bkConf.getEnforceMinNumRacksPerWriteQuorum());
        Assert.assertEquals((int)20, (int)bkConf.getMinNumRacksPerWriteQuorum());
        ((ZooKeeperCache)bkConf.getProperty("zk_cache_instance")).stop();
    }

    @Test
    public void testSetDiskWeightBasedPlacementEnabled() {
        BookKeeperClientFactoryImpl factory = new BookKeeperClientFactoryImpl();
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setZookeeperServers("localhost:2181");
        Assert.assertFalse((boolean)factory.createBkClientConfiguration(conf).getDiskWeightBasedPlacementEnabled());
        conf.setBookkeeperDiskWeightBasedPlacementEnabled(true);
        Assert.assertTrue((boolean)factory.createBkClientConfiguration(conf).getDiskWeightBasedPlacementEnabled());
    }

    @Test
    public void testSetExplicitLacInterval() {
        BookKeeperClientFactoryImpl factory = new BookKeeperClientFactoryImpl();
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setZookeeperServers("localhost:2181");
        Assert.assertEquals((int)factory.createBkClientConfiguration(conf).getExplictLacInterval(), (int)0);
        conf.setBookkeeperExplicitLacIntervalInMills(5);
        Assert.assertEquals((int)factory.createBkClientConfiguration(conf).getExplictLacInterval(), (int)5);
    }

    @Test
    public void testSetMetadataServiceUri() {
        BookKeeperClientFactoryImpl factory = new BookKeeperClientFactoryImpl();
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setZookeeperServers("localhost:2181");
        try {
            String defaultUri = "zk+null://localhost:2181/ledgers";
            Assert.assertEquals((String)factory.createBkClientConfiguration(conf).getMetadataServiceUri(), (String)defaultUri);
            String expectedUri = "zk+hierarchical://localhost:2181/chroot/ledgers";
            conf.setBookkeeperMetadataServiceUri(expectedUri);
            Assert.assertEquals((String)factory.createBkClientConfiguration(conf).getMetadataServiceUri(), (String)expectedUri);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            Assert.fail((String)"Get metadata service uri should be successful", (Throwable)e);
        }
    }

    @Test
    public void testOpportunisticStripingConfiguration() {
        BookKeeperClientFactoryImpl factory = new BookKeeperClientFactoryImpl();
        ServiceConfiguration conf = new ServiceConfiguration();
        Assert.assertFalse((boolean)factory.createBkClientConfiguration(conf).getOpportunisticStriping());
        conf.getProperties().setProperty("bookkeeper_opportunisticStriping", "true");
        Assert.assertTrue((boolean)factory.createBkClientConfiguration(conf).getOpportunisticStriping());
        conf.getProperties().setProperty("bookkeeper_opportunisticStriping", "false");
        Assert.assertFalse((boolean)factory.createBkClientConfiguration(conf).getOpportunisticStriping());
    }
}

