/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockedBookKeeperClientFactory
implements BookKeeperClientFactory {
    private static final Logger log = LoggerFactory.getLogger(MockedBookKeeperClientFactory.class);
    private final BookKeeper mockedBk;
    private final OrderedExecutor executor;

    public MockedBookKeeperClientFactory() {
        try {
            this.executor = OrderedExecutor.newBuilder().numThreads(1).name("mock-bk-client-factory").build();
            this.mockedBk = new PulsarMockBookKeeper(this.executor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) throws IOException {
        return this.mockedBk;
    }

    public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, EventLoopGroup eventLoopGroup, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties, StatsLogger statsLogger) throws IOException {
        return this.mockedBk;
    }

    public void close() {
        try {
            this.mockedBk.close();
        }
        catch (InterruptedException | BKException throwable) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }
}

