/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminApiTest;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProxyProtocol;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.awaitility.Awaitility;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiTest2
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiTest2.class);
    private AdminApiTest.MockedPulsarService mockPulsarSetup;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setEnableNamespaceIsolationUpdateOnTime(true);
        super.internalSetup();
        this.mockPulsarSetup = new AdminApiTest.MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        if (this.mockPulsarSetup != null) {
            this.mockPulsarSetup.cleanup();
        }
        this.resetConfig();
    }

    @DataProvider(name="topicType")
    public Object[][] topicTypeProvider() {
        return new Object[][]{{TopicDomain.persistent.value()}, {TopicDomain.non_persistent.value()}};
    }

    @DataProvider(name="namespaceNames")
    public Object[][] namespaceNameProvider() {
        return new Object[][]{{"ns1"}, {"global"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementPartitionsOfTopic() throws Exception {
        String topicName = "increment-partitionedTopic";
        String subName1 = "increment-partitionedTopic-my-sub-1/encode";
        String subName2 = "increment-partitionedTopic-my-sub-2/encode";
        int startPartitions = 4;
        int newPartitions = 8;
        String partitionedTopicName = "persistent://prop-xyz/ns1/increment-partitionedTopic";
        URL pulsarUrl = new URL(this.pulsar.getWebServiceAddress());
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/increment-partitionedTopic", 4);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").partitions, (int)4);
        PulsarClient client = PulsarClient.builder().serviceUrl(pulsarUrl.toString()).build();
        try {
            int i;
            Consumer consumer1 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-1/encode").subscriptionType(SubscriptionType.Shared).subscribe();
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/ns1/increment-partitionedTopic"), (Collection)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode"}));
            Consumer consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2/encode").subscriptionType(SubscriptionType.Shared).subscribe();
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions("persistent://prop-xyz/ns1/increment-partitionedTopic")), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"}));
            this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/ns1/increment-partitionedTopic", 8);
            Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").partitions, (int)8);
            String newPartitionTopicName = TopicName.get((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").getPartition(5).toString();
            Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/increment-partitionedTopic").enableBatching(false).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).create();
            int totalMessages = 16;
            for (int i2 = 0; i2 < 16; ++i2) {
                String message = "message-" + i2;
                producer.send((Object)message.getBytes());
            }
            consumer2.close();
            consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2/encode").subscriptionType(SubscriptionType.Shared).subscribe();
            this.pulsar.getLocalZkCacheService().managedLedgerListCache().clearTree();
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions(newPartitionTopicName)), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"}));
            Assert.assertEquals((int)Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/ns1")).size(), (int)8);
            PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/increment-partitionedTopic", false);
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1/encode", "increment-partitionedTopic-my-sub-2/encode"})));
            Assert.assertEquals((int)((SubscriptionStats)topicStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2/encode")).getConsumers().size(), (int)1);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2/encode")).getMsgBacklog(), (long)16L);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)1);
            Assert.assertEquals((Map)topicStats.getPartitions(), (Map)Maps.newHashMap());
            topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/increment-partitionedTopic", true);
            Assert.assertEquals((int)topicStats.getMetadata().partitions, (int)8);
            HashSet partitionSet = Sets.newHashSet();
            for (i = 0; i < 8; ++i) {
                partitionSet.add("persistent://prop-xyz/ns1/increment-partitionedTopic-partition-" + i);
            }
            Assert.assertEquals(topicStats.getPartitions().keySet(), (Set)partitionSet);
            for (i = 0; i < 8; ++i) {
                TopicStats partitionStats = (TopicStats)topicStats.getPartitions().get(TopicName.get((String)"persistent://prop-xyz/ns1/increment-partitionedTopic").getPartition(i).toString());
                Assert.assertEquals((int)partitionStats.getPublishers().size(), (int)1);
                Assert.assertEquals((int)((SubscriptionStats)partitionStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2/encode")).getConsumers().size(), (int)1);
                Assert.assertEquals((float)((SubscriptionStats)partitionStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2/encode")).getMsgBacklog(), (float)2.0f, (float)1.0f);
            }
            producer.close();
            consumer1.close();
            consumer2.close();
            consumer2.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopicPoliciesWithMultiBroker() throws Exception {
        this.cleanup();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress() + ",localhost:1026,localhost:2050").build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.conf.setBrokerServicePort(Optional.of(1024));
        this.conf.setBrokerServicePortTls(Optional.of(1025));
        this.conf.setWebServicePort(Optional.of(1026));
        this.conf.setWebServicePortTls(Optional.of(1027));
        PulsarService pulsar2 = this.startBrokerWithoutAuthorization(this.conf);
        try {
            this.conf.setBrokerServicePort(Optional.of(2048));
            this.conf.setBrokerServicePortTls(Optional.of(2049));
            this.conf.setWebServicePort(Optional.of(2050));
            this.conf.setWebServicePortTls(Optional.of(2051));
            PulsarService pulsar3 = this.startBrokerWithoutAuthorization(this.conf);
            try {
                PulsarAdmin admin2 = PulsarAdmin.builder().serviceHttpUrl(pulsar2.getWebServiceAddress()).build();
                try {
                    PulsarAdmin admin3 = PulsarAdmin.builder().serviceHttpUrl(pulsar3.getWebServiceAddress()).build();
                    try {
                        String topic = "persistent://prop-xyz/ns1/" + BrokerTestUtil.newUniqueName("test");
                        int partitionNum = 3;
                        this.admin.topics().createPartitionedTopic(topic, partitionNum);
                        this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName("sub").subscribe().close();
                        this.setTopicPoliciesAndValidate(admin2, admin3, topic);
                        String topic2 = "persistent://prop-xyz/ns1/" + BrokerTestUtil.newUniqueName("test");
                        this.pulsarClient.newConsumer().topic(new String[]{topic2}).subscriptionName("sub").subscribe().close();
                        this.setTopicPoliciesAndValidate(admin2, admin3, topic2);
                    }
                    finally {
                        if (Collections.singletonList(admin3).get(0) != null) {
                            admin3.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(admin2).get(0) != null) {
                        admin2.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(pulsar3).get(0) != null) {
                    pulsar3.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(pulsar2).get(0) != null) {
                pulsar2.close();
            }
        }
    }

    private void setTopicPoliciesAndValidate(PulsarAdmin admin2, PulsarAdmin admin3, String topic) throws Exception {
        this.admin.topics().setMaxUnackedMessagesOnConsumer(topic, 100);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getMaxUnackedMessagesOnConsumer(topic)));
        this.admin.topics().setMaxConsumers(topic, 101);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getMaxConsumers(topic)));
        this.admin.topics().setMaxProducers(topic, 102);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getMaxProducers(topic)));
        Assert.assertEquals((int)this.admin.topics().getMaxUnackedMessagesOnConsumer(topic), (int)100);
        Assert.assertEquals((int)admin2.topics().getMaxUnackedMessagesOnConsumer(topic), (int)100);
        Assert.assertEquals((int)admin3.topics().getMaxUnackedMessagesOnConsumer(topic), (int)100);
        Assert.assertEquals((int)this.admin.topics().getMaxConsumers(topic), (int)101);
        Assert.assertEquals((int)admin2.topics().getMaxConsumers(topic), (int)101);
        Assert.assertEquals((int)admin3.topics().getMaxConsumers(topic), (int)101);
        Assert.assertEquals((int)this.admin.topics().getMaxProducers(topic), (int)102);
        Assert.assertEquals((int)admin2.topics().getMaxProducers(topic), (int)102);
        Assert.assertEquals((int)admin3.topics().getMaxProducers(topic), (int)102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonPersistentTopics() throws Exception {
        String topicName = "nonPersistentTopic";
        String persistentTopicName = "non-persistent://prop-xyz/ns1/nonPersistentTopic";
        this.publishMessagesOnTopic("non-persistent://prop-xyz/ns1/nonPersistentTopic", 0, 0);
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"non-persistent://prop-xyz/ns1/nonPersistentTopic"}).subscriptionName("my-sub").subscribe();
            this.publishMessagesOnTopic("non-persistent://prop-xyz/ns1/nonPersistentTopic", 10, 0);
            TopicStats topicStats = this.admin.topics().getStats("non-persistent://prop-xyz/ns1/nonPersistentTopic");
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            Assert.assertEquals((int)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getConsumers().size(), (int)1);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            PersistentTopicInternalStats internalStats = this.admin.topics().getInternalStats("non-persistent://prop-xyz/ns1/nonPersistentTopic", false);
            Assert.assertEquals(internalStats.cursors.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            consumer.close();
            topicStats = this.admin.topics().getStats("non-persistent://prop-xyz/ns1/nonPersistentTopic");
            Assert.assertTrue((boolean)topicStats.getSubscriptions().containsKey("my-sub"));
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            String partitionedTopicName = "non-persistent://prop-xyz/ns1/paritioned";
            Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/ns1/paritioned").partitions, (int)0);
            this.admin.topics().createPartitionedTopic("non-persistent://prop-xyz/ns1/paritioned", 5);
            Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/ns1/paritioned").partitions, (int)5);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private void publishMessagesOnTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void testSetPersistencePolicies() throws Exception {
        String namespace = "prop-xyz/ns2";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Assert.assertNull((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"));
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 3, 10.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 4, 3, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 4, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(6, 3, 1, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
    }

    @Test
    public void testUpdatePersistencePolicyUpdateManagedCursor() throws Exception {
        String namespace = "prop-xyz/ns2";
        String topicName = "persistent://prop-xyz/ns2/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(3, 3, 3, 50.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/ns2"), (Object)new PersistencePolicies(3, 3, 3, 50.0));
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop-xyz/ns2/topic1").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/ns2/topic1"}).subscriptionName("my-sub").subscribe();
        PersistentTopic topic = (PersistentTopic)this.pulsar.getBrokerService().getOrCreateTopic("persistent://prop-xyz/ns2/topic1").get();
        ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)topic.getManagedLedger();
        ManagedCursorImpl cursor = (ManagedCursorImpl)managedLedger.getCursors().iterator().next();
        double newThrottleRate = 100.0;
        int newEnsembleSize = 5;
        this.admin.namespaces().setPersistence("prop-xyz/ns2", new PersistencePolicies(5, 3, 3, 100.0));
        AdminApiTest2.retryStrategically(test -> managedLedger.getConfig().getEnsembleSize() == 5 && cursor.getThrottleMarkDelete() != 100.0, 5, 200L);
        Assert.assertEquals((double)cursor.getThrottleMarkDelete(), (double)100.0);
        producer.close();
        consumer.close();
    }

    @Test(dataProvider="topicType")
    public void testUnloadTopic(String topicType) throws Exception {
        String namespace = "prop-xyz/ns2";
        String topicName = topicType + "://" + "prop-xyz/ns2" + "/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Topic topic = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).join()).get();
        boolean isPersistentTopic = topic instanceof PersistentTopic;
        this.unloadTopic(topicName);
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        this.pulsarClient.newProducer().topic(topicName).create();
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
        this.unloadTopic(topicName);
        Awaitility.await().until(() -> this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
    }

    private void unloadTopic(String topicName) throws Exception {
        this.admin.topics().unload(topicName);
    }

    @Test(dataProvider="namespaceNames", timeOut=10000L)
    public void testResetCursorOnPosition(String namespaceName) throws Exception {
        String topicName = "persistent://prop-xyz/use/" + namespaceName + "/resetPosition";
        int totalProducedMessages = 50;
        this.admin.namespaces().setRetention("prop-xyz/ns1", new RetentionPolicies(10, 10));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 50, 0);
        List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
        Assert.assertEquals((int)messages.size(), (int)10);
        Message message = null;
        MessageIdImpl resetMessageId = null;
        int resetPositionId = 10;
        for (int i = 0; i < 20; ++i) {
            message = consumer.receive(1, TimeUnit.SECONDS);
            consumer.acknowledge(message);
            if (i != resetPositionId) continue;
            resetMessageId = (MessageIdImpl)message.getMessageId();
        }
        consumer.close();
        MessageIdImpl messageId = new MessageIdImpl(resetMessageId.getLedgerId(), resetMessageId.getEntryId(), -1);
        this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
        consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        MessageIdImpl msgId2 = (MessageIdImpl)consumer.receive(1, TimeUnit.SECONDS).getMessageId();
        Assert.assertEquals((Object)resetMessageId, (Object)msgId2);
        int receivedAfterReset = 1;
        for (int i = 0; i < 50 && (message = consumer.receive(500, TimeUnit.MILLISECONDS)) != null; ++i) {
            consumer.acknowledge(message);
            ++receivedAfterReset;
        }
        Assert.assertEquals((int)receivedAfterReset, (int)(50 - resetPositionId));
        try {
            this.admin.topics().resetCursor(topicName + "invalid", "my-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid topic name");
        }
        catch (PulsarAdminException.NotFoundException i) {
            // empty catch block
        }
        try {
            this.admin.topics().resetCursor(topicName, "invalid-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid subscription name");
        }
        catch (PulsarAdminException.NotFoundException i) {
            // empty catch block
        }
        try {
            messageId = new MessageIdImpl(0L, 0L, -1);
            this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
        }
        catch (PulsarAdminException.PreconditionFailedException e) {
            Assert.fail((String)"It shouldn't fail for a invalid position");
        }
        consumer.close();
    }

    private void publishMessagesOnPersistentTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test(timeOut=20000L)
    public void testMaxConsumersOnSubApi() throws Exception {
        String namespace = "prop-xyz/ns1";
        Assert.assertNull((Object)this.admin.namespaces().getMaxConsumersPerSubscription("prop-xyz/ns1"));
        this.admin.namespaces().setMaxConsumersPerSubscription("prop-xyz/ns1", 10);
        Awaitility.await().untilAsserted(() -> {
            Assert.assertNotNull((Object)this.admin.namespaces().getMaxConsumersPerSubscription("prop-xyz/ns1"));
            Assert.assertEquals((int)this.admin.namespaces().getMaxConsumersPerSubscription("prop-xyz/ns1"), (int)10);
        });
        this.admin.namespaces().removeMaxConsumersPerSubscription("prop-xyz/ns1");
        Awaitility.await().untilAsserted(() -> this.admin.namespaces().getMaxConsumersPerSubscription("prop-xyz/ns1"));
    }

    @Test
    public void testLoadReportApi() throws Exception {
        this.conf.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        AdminApiTest.MockedPulsarService mockPulsarSetup1 = new AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup1.setup();
        PulsarAdmin simpleLoadManagerAdmin = mockPulsarSetup1.getAdmin();
        Assert.assertNotNull((Object)simpleLoadManagerAdmin.brokerStats().getLoadReport());
        this.conf.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        AdminApiTest.MockedPulsarService mockPulsarSetup2 = new AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup2.setup();
        PulsarAdmin modularLoadManagerAdmin = mockPulsarSetup2.getAdmin();
        Assert.assertNotNull((Object)modularLoadManagerAdmin.brokerStats().getLoadReport());
        mockPulsarSetup1.cleanup();
        mockPulsarSetup2.cleanup();
    }

    @Test
    public void testPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", ClusterData.builder().serviceUrl("http://broker.messaging.west1.example.com:8080").build());
        this.admin.clusters().createCluster("us-west2", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-east1", ClusterData.builder().serviceUrl("http://broker.messaging.east1.example.com:8080").build());
        this.admin.clusters().createCluster("us-east2", ClusterData.builder().serviceUrl("http://broker.messaging.east2.example.com:8080").build());
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2"}));
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west2").getPeerClusterNames());
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1", "us-west2", "us-east1", "us-west2", "us-east1"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1"}));
        this.admin.clusters().updatePeerClusterNames("us-west1", null);
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west1").getPeerClusterNames());
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"invalid-cluster"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west1"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void testReplicationPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", ClusterData.builder().serviceUrl("http://broker.messaging.west1.example.com:8080").build());
        this.admin.clusters().createCluster("us-west2", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-west3", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-west4", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-east1", ClusterData.builder().serviceUrl("http://broker.messaging.east1.example.com:8080").build());
        this.admin.clusters().createCluster("us-east2", ClusterData.builder().serviceUrl("http://broker.messaging.east2.example.com:8080").build());
        this.admin.clusters().createCluster("global", ClusterData.builder().build());
        List allClusters = this.admin.clusters().getClusters();
        Collections.sort(allClusters);
        Assert.assertEquals((Collection)allClusters, (Collection)Lists.newArrayList((Object[])new String[]{"test", "us-east1", "us-east2", "us-west1", "us-west2", "us-west3", "us-west4"}));
        String property = "peer-prop";
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west2", "us-west3", "us-west4", "us-east1", "us-east2", "global"});
        TenantInfoImpl propConfig = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"test"}), (Set)allowedClusters);
        this.admin.tenants().createTenant("peer-prop", (TenantInfo)propConfig);
        String namespace = "peer-prop/global/conflictPeer";
        this.admin.namespaces().createNamespace("peer-prop/global/conflictPeer");
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"}));
        HashSet clusterIds = Sets.newHashSet((Object[])new String[]{"us-east1", "us-east2"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3", "us-west1"});
        try {
            this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
            Assert.fail((String)"Peer-cluster can't coexist in replication cluster list");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west4"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
    }

    @Test
    public void clusterFailureDomain() throws PulsarAdminException {
        String cluster = this.pulsar.getConfiguration().getClusterName();
        FailureDomain domain = FailureDomain.builder().brokers((Set)Sets.newHashSet((Object[])new String[]{"b1", "b2", "b3"})).build();
        this.admin.clusters().createFailureDomain(cluster, "domain-1", domain);
        this.admin.clusters().updateFailureDomain(cluster, "domain-1", domain);
        Assert.assertEquals((Object)this.admin.clusters().getFailureDomain(cluster, "domain-1"), (Object)domain);
        Map domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-1"));
        try {
            this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
            Assert.fail((String)"should have failed because of brokers are already registered");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        this.admin.clusters().deleteFailureDomain(cluster, "domain-1");
        Assert.assertTrue((boolean)this.admin.clusters().getFailureDomains(cluster).isEmpty());
        this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
        domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-2"));
    }

    @Test
    public void namespaceAntiAffinity() throws PulsarAdminException {
        String namespace = "prop-xyz/ns1";
        String antiAffinityGroup = "group";
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1")));
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/ns1", "group");
        Assert.assertEquals((String)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1"), (String)"group");
        this.admin.namespaces().deleteNamespaceAntiAffinityGroup("prop-xyz/ns1");
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/ns1")));
        String ns1 = "prop-xyz/antiAG1";
        String ns2 = "prop-xyz/antiAG2";
        String ns3 = "prop-xyz/antiAG3";
        this.admin.namespaces().createNamespace("prop-xyz/antiAG1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/antiAG2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz/antiAG3", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG1", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG2", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/antiAG3", "group");
        HashSet namespaces = new HashSet(this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "test", "group"));
        Assert.assertEquals((int)namespaces.size(), (int)3);
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG1"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG2"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/antiAG3"));
        List namespaces2 = this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "test", "invalid-group");
        Assert.assertEquals((int)namespaces2.size(), (int)0);
    }

    @Test
    public void testNonPersistentTopics() throws Exception {
        int i;
        String namespace = "prop-xyz/ns2";
        String topicName = "non-persistent://prop-xyz/ns2/topic";
        this.admin.namespaces().createNamespace("prop-xyz/ns2", 20);
        this.admin.namespaces().setNamespaceReplicationClusters("prop-xyz/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        int totalTopics = 100;
        HashSet topicNames = Sets.newHashSet();
        for (i = 0; i < totalTopics; ++i) {
            topicNames.add("non-persistent://prop-xyz/ns2/topic" + i);
            Producer producer = this.pulsarClient.newProducer().topic("non-persistent://prop-xyz/ns2/topic" + i).create();
            producer.close();
        }
        for (i = 0; i < totalTopics; ++i) {
            Topic topic = (Topic)this.pulsar.getBrokerService().getTopicReference("non-persistent://prop-xyz/ns2/topic" + i).get();
            Assert.assertNotNull((Object)topic);
        }
        HashSet topicsInNs = Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/ns2"));
        Assert.assertEquals((int)topicsInNs.size(), (int)totalTopics);
        topicsInNs.removeAll(topicNames);
        Assert.assertEquals((int)topicsInNs.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishConsumerStats() throws Exception {
        String topicName = "statTopic";
        String subscriberName = "statTopic-my-sub-1";
        String topic = "persistent://prop-xyz/ns1/statTopic";
        String producerName = "myProducer";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/statTopic"}).subscriptionName("statTopic-my-sub-1").subscriptionType(SubscriptionType.Shared).subscribe();
            Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/statTopic").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).producerName("myProducer").create();
            AdminApiTest2.retryStrategically(test -> {
                try {
                    TopicStats stats = this.admin.topics().getStats("persistent://prop-xyz/ns1/statTopic");
                    return stats.getPublishers().size() > 0 && stats.getSubscriptions().get("statTopic-my-sub-1") != null && ((SubscriptionStats)stats.getSubscriptions().get("statTopic-my-sub-1")).getConsumers().size() > 0;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 5, 200L);
            TopicStats topicStats = this.admin.topics().getStats("persistent://prop-xyz/ns1/statTopic");
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)1);
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getAddress());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getClientVersion());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getConnectedSince());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getProducerName());
            Assert.assertEquals((String)((PublisherStats)topicStats.getPublishers().get(0)).getProducerName(), (String)"myProducer");
            SubscriptionStats subscriber = (SubscriptionStats)topicStats.getSubscriptions().get("statTopic-my-sub-1");
            Assert.assertNotNull((Object)subscriber);
            Assert.assertEquals((int)subscriber.getConsumers().size(), (int)1);
            ConsumerStats consumerStats = (ConsumerStats)subscriber.getConsumers().get(0);
            Assert.assertNotNull((Object)consumerStats.getAddress());
            Assert.assertNotNull((Object)consumerStats.getClientVersion());
            Assert.assertNotNull((Object)consumerStats.getConnectedSince());
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testTenantNameWithUnderscore() throws Exception {
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop_xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop_xyz/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://prop_xyz/use/my-namespace/my-topic";
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        TopicStats stats = this.admin.topics().getStats(topic);
        Assert.assertEquals((int)stats.getPublishers().size(), (int)1);
        producer.close();
    }

    @Test
    public void testTenantNameWithInvalidCharacters() {
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        try {
            this.admin.tenants().createTenant("prop xyz", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.admin.tenants().createTenant("prop&xyz", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testTenantWithNonexistentClusters() throws Exception {
        Assert.assertFalse((boolean)this.admin.clusters().getClusters().contains("cluster-non-existing"));
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"cluster-non-existing"});
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)allowedClusters);
        try {
            this.admin.tenants().createTenant("test-tenant", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        Assert.assertFalse((boolean)this.admin.tenants().getTenants().contains("test-tenant"));
        Assert.assertTrue((boolean)this.admin.tenants().getTenants().contains("prop-xyz"));
        try {
            this.admin.tenants().updateTenant("prop-xyz", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void brokerNamespaceIsolationPolicies() throws Exception {
        String policyName1 = "policy-1";
        String cluster = this.pulsar.getConfiguration().getClusterName();
        String namespaceRegex = "other/" + cluster + "/other.*";
        String brokerName = this.pulsar.getAdvertisedAddress();
        String brokerAddress = brokerName + ":" + this.pulsar.getConfiguration().getWebServicePort().get();
        HashMap<String, String> parameters1 = new HashMap<String, String>();
        parameters1.put("min_limit", "1");
        parameters1.put("usage_threshold", "100");
        NamespaceIsolationData nsPolicyData1 = NamespaceIsolationData.builder().namespaces(Collections.singletonList(namespaceRegex)).primary(Collections.singletonList(brokerName + ":[0-9]*")).secondary(Collections.singletonList(brokerName + ".*")).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters1).build()).build();
        this.admin.clusters().createNamespaceIsolationPolicy(cluster, policyName1, nsPolicyData1);
        List brokerIsolationDataList = this.admin.clusters().getBrokersWithNamespaceIsolationPolicy(cluster);
        Assert.assertEquals((int)brokerIsolationDataList.size(), (int)1);
        Assert.assertEquals((String)((BrokerNamespaceIsolationData)brokerIsolationDataList.get(0)).getBrokerName(), (String)brokerAddress);
        Assert.assertEquals((int)((BrokerNamespaceIsolationData)brokerIsolationDataList.get(0)).getNamespaceRegex().size(), (int)1);
        Assert.assertEquals((String)((String)((BrokerNamespaceIsolationData)brokerIsolationDataList.get(0)).getNamespaceRegex().get(0)), (String)namespaceRegex);
        BrokerNamespaceIsolationDataImpl brokerIsolationData = (BrokerNamespaceIsolationDataImpl)this.admin.clusters().getBrokerWithNamespaceIsolationPolicy(cluster, brokerAddress);
        Assert.assertEquals((String)brokerIsolationData.getBrokerName(), (String)brokerAddress);
        Assert.assertEquals((int)brokerIsolationData.getNamespaceRegex().size(), (int)1);
        Assert.assertEquals((String)((String)brokerIsolationData.getNamespaceRegex().get(0)), (String)namespaceRegex);
        BrokerNamespaceIsolationDataImpl isolationData = (BrokerNamespaceIsolationDataImpl)this.admin.clusters().getBrokerWithNamespaceIsolationPolicy(cluster, "invalid-broker");
        Assert.assertFalse((boolean)isolationData.isPrimary());
    }

    @Test
    public void brokerNamespaceIsolationPoliciesUpdateOnTime() throws Exception {
        String brokerName = this.pulsar.getAdvertisedAddress();
        String ns1Name = "prop-xyz/test_ns1_iso_" + System.currentTimeMillis();
        this.admin.namespaces().createNamespace(ns1Name, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String brokerUrl = this.admin.lookups().lookupTopic(ns1Name + "/topic1");
        Assert.assertTrue((boolean)brokerUrl.contains(brokerName));
        log.info("0 get lookup url {}", (Object)brokerUrl);
        String policyName1 = "policy-1";
        String cluster = this.pulsar.getConfiguration().getClusterName();
        HashMap<String, String> parameters1 = new HashMap<String, String>();
        parameters1.put("min_limit", "1");
        parameters1.put("usage_threshold", "100");
        NamespaceIsolationData nsPolicyData1 = NamespaceIsolationData.builder().namespaces(Collections.singletonList(ns1Name)).primary(Collections.singletonList(brokerName + ".*")).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters1).build()).build();
        this.admin.clusters().createNamespaceIsolationPolicyAsync(cluster, policyName1, nsPolicyData1).get();
        brokerUrl = this.admin.lookups().lookupTopic(ns1Name + "/topic2");
        Assert.assertTrue((boolean)brokerUrl.contains(brokerName));
        log.info(" 1 get lookup url {}", (Object)brokerUrl);
        nsPolicyData1.getPrimary().clear();
        nsPolicyData1.getPrimary().add(brokerName + "not_match");
        this.admin.clusters().updateNamespaceIsolationPolicyAsync(cluster, policyName1, nsPolicyData1).get();
        try {
            this.admin.lookups().lookupTopic(ns1Name + "/topic3");
        }
        catch (Exception e) {
            log.info(" 2 expected fail lookup");
        }
        try {
            this.admin.lookups().lookupTopic(ns1Name + "/topic1");
        }
        catch (Exception e) {
            log.info(" 22 expected fail lookup");
        }
    }

    @Test
    public void clustersList() throws PulsarAdminException {
        String cluster = this.pulsar.getConfiguration().getClusterName();
        this.admin.clusters().createCluster("global", ClusterData.builder().serviceUrl("http://localhost:6650").build());
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{cluster}));
    }

    @Test
    public void testClusterIsReadyBeforeCreateTopic() throws PulsarAdminException {
        String topicName = "partitionedTopic";
        int partitions = 4;
        String persistentPartitionedTopicName = "persistent://prop-xyz/ns2/partitionedTopic";
        String NonPersistentPartitionedTopicName = "non-persistent://prop-xyz/ns2/partitionedTopic";
        this.admin.namespaces().createNamespace("prop-xyz/ns2");
        this.admin.namespaces().setNamespaceReplicationClusters("prop-xyz/ns2", new HashSet());
        try {
            this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns2/partitionedTopic", 4);
            Assert.fail((String)"should have failed due to Namespace does not have any clusters configured");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        try {
            this.admin.topics().createPartitionedTopic("non-persistent://prop-xyz/ns2/partitionedTopic", 4);
            Assert.fail((String)"should have failed due to Namespace does not have any clusters configured");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateNamespaceWithNoClusters() throws PulsarAdminException {
        String localCluster = this.pulsar.getConfiguration().getClusterName();
        String namespace = "prop-xyz/test-ns-with-no-clusters";
        this.admin.namespaces().createNamespace(namespace);
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaceReplicationClusters(namespace), Collections.singletonList(localCluster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testConsumerStatsLastTimestamp() throws PulsarClientException, PulsarAdminException, InterruptedException {
        long timestamp = System.currentTimeMillis();
        String topicName = "consumer-stats-" + timestamp;
        String subscribeName = topicName + "-test-stats-sub";
        String topic = "persistent://prop-xyz/ns1/" + topicName;
        String producerName = "producer-" + topicName;
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Producer producer = client.newProducer().topic(topic).enableBatching(false).producerName(producerName).create();
            producer.send((Object)"message-1".getBytes(StandardCharsets.UTF_8));
            Consumer consumer = client.newConsumer().topic(new String[]{topic}).subscriptionName(subscribeName).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            Message message = consumer.receive();
            TopicStats topicStats = this.admin.topics().getStats(topic);
            SubscriptionStats subscriptionStats = (SubscriptionStats)topicStats.getSubscriptions().get(subscribeName);
            long startConsumedFlowTimestamp = subscriptionStats.getLastConsumedFlowTimestamp();
            long startAckedTimestampInSubStats = subscriptionStats.getLastAckedTimestamp();
            ConsumerStats consumerStats = (ConsumerStats)subscriptionStats.getConsumers().get(0);
            long startConsumedTimestampInConsumerStats = consumerStats.getLastConsumedTimestamp();
            long startAckedTimestampInConsumerStats = consumerStats.getLastAckedTimestamp();
            Assert.assertNotEquals((Object)0, (Object)startConsumedTimestampInConsumerStats);
            Assert.assertEquals((long)0L, (long)startAckedTimestampInConsumerStats);
            Assert.assertNotEquals((Object)0, (Object)startConsumedFlowTimestamp);
            Assert.assertEquals((long)0L, (long)startAckedTimestampInSubStats);
            consumer.acknowledge(message);
            while (((SubscriptionStats)(topicStats = this.admin.topics().getStats(topic)).getSubscriptions().get(subscribeName)).getLastAckedTimestamp() == 0L) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            topicStats = this.admin.topics().getStats(topic);
            subscriptionStats = (SubscriptionStats)topicStats.getSubscriptions().get(subscribeName);
            long consumedFlowTimestamp = subscriptionStats.getLastConsumedFlowTimestamp();
            long ackedTimestampInSubStats = subscriptionStats.getLastAckedTimestamp();
            consumerStats = (ConsumerStats)subscriptionStats.getConsumers().get(0);
            long consumedTimestamp = consumerStats.getLastConsumedTimestamp();
            long ackedTimestamp = consumerStats.getLastAckedTimestamp();
            Assert.assertEquals((long)startConsumedTimestampInConsumerStats, (long)consumedTimestamp);
            Assert.assertTrue((startAckedTimestampInConsumerStats < ackedTimestamp ? 1 : 0) != 0);
            Assert.assertNotEquals((Object)0, (Object)consumedFlowTimestamp);
            Assert.assertTrue((startAckedTimestampInSubStats < ackedTimestampInSubStats ? 1 : 0) != 0);
            producer.send((Object)"message-2".getBytes(StandardCharsets.UTF_8));
            message = consumer.receive();
            consumer.acknowledge(message);
            while (((SubscriptionStats)(topicStats = this.admin.topics().getStats(topic)).getSubscriptions().get(subscribeName)).getLastAckedTimestamp() == ackedTimestampInSubStats) {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            topicStats = this.admin.topics().getStats(topic);
            subscriptionStats = (SubscriptionStats)topicStats.getSubscriptions().get(subscribeName);
            long lastConsumedFlowTimestamp = subscriptionStats.getLastConsumedFlowTimestamp();
            long lastConsumedTimestampInSubStats = subscriptionStats.getLastConsumedTimestamp();
            long lastAckedTimestampInSubStats = subscriptionStats.getLastAckedTimestamp();
            consumerStats = (ConsumerStats)subscriptionStats.getConsumers().get(0);
            long lastConsumedTimestamp = consumerStats.getLastConsumedTimestamp();
            long lastAckedTimestamp = consumerStats.getLastAckedTimestamp();
            Assert.assertTrue((consumedTimestamp < lastConsumedTimestamp ? 1 : 0) != 0);
            Assert.assertTrue((ackedTimestamp < lastAckedTimestamp ? 1 : 0) != 0);
            Assert.assertTrue((startConsumedTimestampInConsumerStats < lastConsumedTimestamp ? 1 : 0) != 0);
            Assert.assertEquals((long)lastConsumedFlowTimestamp, (long)consumedFlowTimestamp);
            Assert.assertTrue((ackedTimestampInSubStats < lastAckedTimestampInSubStats ? 1 : 0) != 0);
            Assert.assertEquals((long)lastConsumedTimestamp, (long)lastConsumedTimestampInSubStats);
            consumer.close();
            producer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testPreciseBacklog() throws PulsarClientException, PulsarAdminException, InterruptedException {
        String topic = "persistent://prop-xyz/ns1/precise-back-log";
        String subName = "sub-name";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/precise-back-log"}).subscriptionName("sub-name").acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            try {
                Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/precise-back-log").enableBatching(false).create();
                try {
                    producer.send((Object)"message-1".getBytes(StandardCharsets.UTF_8));
                    Message message = consumer.receive();
                    Assert.assertNotNull((Object)message);
                    PersistentSubscription subscription = (PersistentSubscription)((Topic)this.pulsar.getBrokerService().getTopicReference("persistent://prop-xyz/ns1/precise-back-log").get()).getSubscription("sub-name");
                    Assert.assertNotNull((Object)subscription);
                    ((ManagedLedgerImpl)subscription.getCursor().getManagedLedger()).setEntriesAddedCounter(10L);
                    TopicStats topicStats = this.admin.topics().getStats("persistent://prop-xyz/ns1/precise-back-log");
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)10L);
                    topicStats = this.admin.topics().getStats("persistent://prop-xyz/ns1/precise-back-log", true, true);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getBacklogSize(), (long)43L);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)1L);
                    consumer.acknowledge(message);
                    Awaitility.await().untilAsserted(() -> {
                        TopicStats topicStats2 = this.admin.topics().getStats("persistent://prop-xyz/ns1/precise-back-log", true, true);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats2.getSubscriptions().get("sub-name")).getBacklogSize(), (long)0L);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats2.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)0L);
                    });
                    topicStats = this.admin.topics().getStats("persistent://prop-xyz/ns1/precise-back-log");
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)9L);
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testBacklogNoDelayed() throws PulsarClientException, PulsarAdminException, InterruptedException {
        String topic = "persistent://prop-xyz/ns1/precise-back-log-no-delayed-" + UUID.randomUUID().toString();
        String subName = "sub-name";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{topic}).subscriptionName("sub-name").subscriptionType(SubscriptionType.Shared).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            try {
                Producer producer = client.newProducer().topic(topic).enableBatching(false).create();
                try {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        if (i > 4) {
                            producer.newMessage().value((Object)"message-1".getBytes(StandardCharsets.UTF_8)).deliverAfter(10L, TimeUnit.SECONDS).send();
                            continue;
                        }
                        producer.send((Object)"message-1".getBytes(StandardCharsets.UTF_8));
                    }
                    Awaitility.await().untilAsserted(() -> {
                        TopicStats topicStats = this.admin.topics().getStats(topic, true, true);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)10L);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklogNoDelayed(), (long)5L);
                    });
                    for (i = 0; i < 5; ++i) {
                        consumer.acknowledge(consumer.receive());
                    }
                    Awaitility.await().untilAsserted(() -> {
                        TopicStats topicStats = this.admin.topics().getStats(topic, true, true);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)5L);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklogNoDelayed(), (long)0L);
                    });
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreciseBacklogForPartitionedTopic() throws PulsarClientException, PulsarAdminException {
        String topic = "persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic", 2);
        String subName = "sub-name";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic"}).subscriptionName("sub-name").acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            try {
                Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic").enableBatching(false).create();
                try {
                    producer.send((Object)"message-1".getBytes(StandardCharsets.UTF_8));
                    Message message = consumer.receive();
                    Assert.assertNotNull((Object)message);
                    for (int i = 0; i < 2; ++i) {
                        PersistentSubscription subscription = (PersistentSubscription)((Topic)this.pulsar.getBrokerService().getTopicReference("persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic-partition-" + i).get()).getSubscription("sub-name");
                        Assert.assertNotNull((Object)subscription);
                        ((ManagedLedgerImpl)subscription.getCursor().getManagedLedger()).setEntriesAddedCounter(10L);
                    }
                    PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic", false);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)20L);
                    topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/precise-back-log-for-partitioned-topic", false, true, true);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)1L);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getBacklogSize(), (long)43L);
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testBacklogNoDelayedForPartitionedTopic() throws PulsarClientException, PulsarAdminException, InterruptedException {
        String topic = "persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic", 2);
        String subName = "sub-name";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic"}).subscriptionName("sub-name").subscriptionType(SubscriptionType.Shared).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
            try {
                Producer producer = client.newProducer().topic("persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic").enableBatching(false).create();
                try {
                    for (int i = 0; i < 10; ++i) {
                        if (i > 4) {
                            producer.newMessage().value((Object)"message-1".getBytes(StandardCharsets.UTF_8)).deliverAfter(10L, TimeUnit.SECONDS).send();
                            continue;
                        }
                        producer.send((Object)"message-1".getBytes(StandardCharsets.UTF_8));
                    }
                    PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic", false, true, true);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)10L);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getBacklogSize(), (long)470L);
                    Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("sub-name")).getMsgBacklogNoDelayed(), (long)5L);
                    for (int i = 0; i < 5; ++i) {
                        consumer.acknowledge(consumer.receive());
                    }
                    Awaitility.await().untilAsserted(() -> {
                        PartitionedTopicStats topicStats2 = this.admin.topics().getPartitionedStats("persistent://prop-xyz/ns1/precise-back-log-no-delayed-partitioned-topic", false, true, true);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats2.getSubscriptions().get("sub-name")).getMsgBacklog(), (long)5L);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats2.getSubscriptions().get("sub-name")).getBacklogSize(), (long)238L);
                        Assert.assertEquals((long)((SubscriptionStats)topicStats2.getSubscriptions().get("sub-name")).getMsgBacklogNoDelayed(), (long)0L);
                    });
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testMaxNumPartitionsPerPartitionedTopicSuccess() {
        String topic = "persistent://prop-xyz/ns1/max-num-partitions-per-partitioned-topic-success";
        this.pulsar.getConfiguration().setMaxNumPartitionsPerPartitionedTopic(3);
        try {
            this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/max-num-partitions-per-partitioned-topic-success", 2);
        }
        catch (Exception e) {
            Assert.fail((String)"should not throw any exceptions");
        }
        this.pulsar.getConfiguration().setMaxNumPartitionsPerPartitionedTopic(0);
    }

    @Test
    public void testMaxNumPartitionsPerPartitionedTopicFailure() {
        String topic = "persistent://prop-xyz/ns1/max-num-partitions-per-partitioned-topic-failure";
        this.pulsar.getConfiguration().setMaxNumPartitionsPerPartitionedTopic(2);
        try {
            this.admin.topics().createPartitionedTopic("persistent://prop-xyz/ns1/max-num-partitions-per-partitioned-topic-failure", 3);
            Assert.fail((String)"should throw exception when number of partitions exceed than max partitions");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException));
        }
        this.pulsar.getConfiguration().setMaxNumPartitionsPerPartitionedTopic(0);
    }

    @Test
    public void testListOfNamespaceBundles() throws Exception {
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz2", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz2/ns1", 10);
        this.admin.namespaces().setNamespaceReplicationClusters("prop-xyz2/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("prop-xyz2/test/ns2", 10);
        Assert.assertEquals((int)this.admin.namespaces().getBundles("prop-xyz2/ns1").getNumBundles(), (int)10);
        Assert.assertEquals((int)this.admin.namespaces().getBundles("prop-xyz2/test/ns2").getNumBundles(), (int)10);
    }

    @Test
    public void testForceDeleteNamespace() throws Exception {
        this.conf.setForceDeleteNamespaceAllowed(true);
        String namespaceName = "prop-xyz2/ns1";
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz2", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz2/ns1", 1);
        String topic = "persistent://prop-xyz2/ns1/test" + UUID.randomUUID();
        this.pulsarClient.newProducer(Schema.DOUBLE).topic(topic).create().close();
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.schemas().getSchemaInfo(topic)));
        this.admin.namespaces().deleteNamespace("prop-xyz2/ns1", true);
        try {
            this.admin.schemas().getSchemaInfo(topic);
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)404);
        }
    }

    @Test
    public void testUpdateClusterWithProxyUrl() throws Exception {
        ClusterData cluster = ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        String clusterName = "test2";
        this.admin.clusters().createCluster(clusterName, cluster);
        Assert.assertEquals((Object)this.admin.clusters().getCluster(clusterName), (Object)cluster);
        cluster = ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).proxyServiceUrl("proxy").proxyProtocol(ProxyProtocol.SNI).build();
        this.admin.clusters().updateCluster(clusterName, cluster);
        Assert.assertEquals((Object)this.admin.clusters().getCluster(clusterName), (Object)cluster);
    }

    @Test
    public void testMaxNamespacesPerTenant() throws Exception {
        super.internalCleanup();
        this.conf.setMaxNamespacesPerTenant(2);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().createNamespace("testTenant/ns2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        try {
            this.admin.namespaces().createNamespace("testTenant/ns3", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
            Assert.assertEquals((String)e.getHttpError(), (String)"Exceed the maximum number of namespace in tenant :testTenant");
        }
        super.internalCleanup();
        this.conf.setMaxNamespacesPerTenant(0);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        for (int i = 0; i < 10; ++i) {
            this.admin.namespaces().createNamespace("testTenant/ns-" + i, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        }
    }

    @Test
    public void testMaxTopicsPerNamespace() throws Exception {
        int i;
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(10);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://testTenant/ns1/test_create_topic_v";
        this.admin.topics().createPartitionedTopic(topic + "1", 2);
        this.admin.topics().createPartitionedTopic(topic + "2", 3);
        this.admin.topics().createPartitionedTopic(topic + "3", 4);
        this.admin.topics().createNonPartitionedTopic(topic + "4");
        try {
            this.admin.topics().createPartitionedTopic(topic + "5", 2);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
            Assert.assertEquals((String)e.getHttpError(), (String)"Exceed maximum number of topics in namespace.");
        }
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(0);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        for (i = 0; i < 10; ++i) {
            this.admin.topics().createPartitionedTopic(topic + i, 2);
            this.admin.topics().createNonPartitionedTopic(topic + i + i);
        }
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(5);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        for (i = 0; i < 5; ++i) {
            this.admin.topics().createPartitionedTopic(topic + i, 1);
        }
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__change_events", 2);
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__transaction_buffer_snapshot", 2);
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__transaction_buffer_snapshot-multiTopicsReader-05c0ded5e9__transaction_pending_ack", 2);
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(5);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__change_events", 2);
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__transaction_buffer_snapshot", 2);
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/__transaction_buffer_snapshot-multiTopicsReader-05c0ded5e9__transaction_pending_ack", 2);
        for (i = 0; i < 5; ++i) {
            this.admin.topics().createPartitionedTopic(topic + i, 1);
        }
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(10);
        this.conf.setDefaultNumPartitions(3);
        this.conf.setAllowAutoTopicCreationType("partitioned");
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.pulsarClient.newProducer().topic(topic + "1").create().close();
        this.pulsarClient.newProducer().topic(topic + "2").create().close();
        this.pulsarClient.newConsumer().topic(new String[]{topic + "3"}).subscriptionName("test_sub").subscribe().close();
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topic + "4"}).subscriptionName("test_sub").subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("Exception: ", (Throwable)e);
        }
        super.internalCleanup();
        this.conf.setMaxTopicsPerNamespace(3);
        this.conf.setAllowAutoTopicCreationType("non-partitioned");
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.pulsarClient.newProducer().topic(topic + "1").create().close();
        this.pulsarClient.newProducer().topic(topic + "2").create().close();
        this.pulsarClient.newConsumer().topic(new String[]{topic + "3"}).subscriptionName("test_sub").subscribe().close();
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topic + "4"}).subscriptionName("test_sub").subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("Exception: ", (Throwable)e);
        }
        this.conf.setMaxTopicsPerNamespace(0);
        this.conf.setDefaultNumPartitions(1);
    }

    @Test
    public void testInvalidBundleErrorResponse() throws Exception {
        try {
            this.admin.namespaces().deleteNamespaceBundle("prop-xyz/ns1", "invalid-bundle");
            Assert.fail((String)"should have failed due to invalid bundle");
        }
        catch (PulsarAdminException.PreconditionFailedException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid bundle range"));
        }
    }

    @Test
    public void testMaxSubscriptionsPerTopic() throws Exception {
        super.internalCleanup();
        this.conf.setMaxSubscriptionsPerTopic(2);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://testTenant/ns1/max-subscriptions-per-topic";
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/max-subscriptions-per-topic", 3);
        Producer producer = this.pulsarClient.newProducer().topic("persistent://testTenant/ns1/max-subscriptions-per-topic").create();
        producer.close();
        this.admin.topics().createSubscription("persistent://testTenant/ns1/max-subscriptions-per-topic", "test-sub1", MessageId.earliest);
        this.admin.topics().createSubscription("persistent://testTenant/ns1/max-subscriptions-per-topic", "test-sub2", MessageId.earliest);
        try {
            this.admin.topics().createSubscription("persistent://testTenant/ns1/max-subscriptions-per-topic", "test-sub3", MessageId.earliest);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            log.info("create subscription failed. Exception: ", (Throwable)e);
        }
        super.internalCleanup();
        this.conf.setMaxSubscriptionsPerTopic(0);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/max-subscriptions-per-topic", 3);
        producer = this.pulsarClient.newProducer().topic("persistent://testTenant/ns1/max-subscriptions-per-topic").create();
        producer.close();
        for (int i = 0; i < 10; ++i) {
            this.admin.topics().createSubscription("persistent://testTenant/ns1/max-subscriptions-per-topic", "test-sub" + i, MessageId.earliest);
        }
        super.internalCleanup();
        this.conf.setMaxSubscriptionsPerTopic(2);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("testTenant/ns1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://testTenant/ns1/max-subscriptions-per-topic", 3);
        producer = this.pulsarClient.newProducer().topic("persistent://testTenant/ns1/max-subscriptions-per-topic").create();
        producer.close();
        Consumer consumer1 = null;
        Consumer consumer2 = null;
        Consumer consumer3 = null;
        try {
            consumer1 = this.pulsarClient.newConsumer().subscriptionName("test-sub1").topic(new String[]{"persistent://testTenant/ns1/max-subscriptions-per-topic"}).subscribe();
            Assert.assertNotNull((Object)consumer1);
        }
        catch (PulsarClientException e) {
            Assert.fail();
        }
        try {
            consumer2 = this.pulsarClient.newConsumer().subscriptionName("test-sub2").topic(new String[]{"persistent://testTenant/ns1/max-subscriptions-per-topic"}).subscribe();
            Assert.assertNotNull((Object)consumer2);
        }
        catch (PulsarClientException e) {
            Assert.fail();
        }
        try {
            consumer3 = this.pulsarClient.newConsumer().subscriptionName("test-sub3").topic(new String[]{"persistent://testTenant/ns1/max-subscriptions-per-topic"}).subscribe();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("subscription reached max subscriptions per topic");
        }
        consumer1.close();
        consumer2.close();
        this.admin.topics().deletePartitionedTopic("persistent://testTenant/ns1/max-subscriptions-per-topic");
    }

    @Test(timeOut=30000L)
    public void testMaxSubPerTopicApi() throws Exception {
        String myNamespace = "prop-xyz/ns" + UUID.randomUUID();
        this.admin.namespaces().createNamespace(myNamespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Assert.assertNull((Object)this.admin.namespaces().getMaxSubscriptionsPerTopic(myNamespace));
        this.admin.namespaces().setMaxSubscriptionsPerTopic(myNamespace, 100);
        Assert.assertEquals((int)this.admin.namespaces().getMaxSubscriptionsPerTopic(myNamespace), (int)100);
        this.admin.namespaces().removeMaxSubscriptionsPerTopic(myNamespace);
        Assert.assertNull((Object)this.admin.namespaces().getMaxSubscriptionsPerTopic(myNamespace));
        this.admin.namespaces().setMaxSubscriptionsPerTopicAsync(myNamespace, 200).get();
        Assert.assertEquals((int)((Integer)this.admin.namespaces().getMaxSubscriptionsPerTopicAsync(myNamespace).get()), (int)200);
        this.admin.namespaces().removeMaxSubscriptionsPerTopicAsync(myNamespace);
        Awaitility.await().untilAsserted(() -> Assert.assertNull(this.admin.namespaces().getMaxSubscriptionsPerTopicAsync(myNamespace).get()));
        try {
            this.admin.namespaces().setMaxSubscriptionsPerTopic(myNamespace, -100);
            Assert.fail((String)"should fail");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
    }

    @Test(timeOut=30000L)
    public void testMaxSubPerTopic() throws Exception {
        String myNamespace = "prop-xyz/ns" + UUID.randomUUID();
        this.admin.namespaces().createNamespace(myNamespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://" + myNamespace + "/testMaxSubPerTopic";
        this.pulsarClient.newProducer().topic(topic).create().close();
        int maxSub = 2;
        this.admin.namespaces().setMaxSubscriptionsPerTopic(myNamespace, 2);
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
        Field field = PersistentTopic.class.getSuperclass().getDeclaredField("maxSubscriptionsPerTopic");
        field.setAccessible(true);
        Awaitility.await().until(() -> (Integer)field.get(persistentTopic) == 2);
        ArrayList<Consumer> consumerList = new ArrayList<Consumer>(2);
        for (int i = 0; i < 2; ++i) {
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
            consumerList.add(consumer);
        }
        try {
            PulsarClient client = PulsarClient.builder().operationTimeout(2, TimeUnit.SECONDS).serviceUrl(this.brokerUrl.toString()).build();
            Object object = null;
            try {
                client.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
                Assert.fail((String)"should fail");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (Exception client) {
            // empty catch block
        }
        this.admin.namespaces().removeMaxSubscriptionsPerTopic(myNamespace);
        Awaitility.await().until(() -> field.get(persistentTopic) == null);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
        consumerList.add(consumer);
        for (Consumer c : consumerList) {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testMaxSubPerTopicPriority() throws Exception {
        int brokerLevelMaxSub = 2;
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
        this.conf.setMaxSubscriptionsPerTopic(2);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        String myNamespace = "prop-xyz/ns" + UUID.randomUUID();
        this.admin.namespaces().createNamespace(myNamespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://" + myNamespace + "/testMaxSubPerTopic";
        PulsarClient client = PulsarClient.builder().operationTimeout(2, TimeUnit.SECONDS).serviceUrl(this.brokerUrl.toString()).build();
        try {
            ArrayList<Consumer> consumerList = new ArrayList<Consumer>(2);
            for (int i = 0; i < 2; ++i) {
                Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
                consumerList.add(consumer);
            }
            try {
                client.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
                Assert.fail((String)"should fail");
            }
            catch (Exception i) {
                // empty catch block
            }
            int nsLevelMaxSub = 4;
            this.admin.namespaces().setMaxSubscriptionsPerTopic(myNamespace, 4);
            PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
            Field field = PersistentTopic.class.getSuperclass().getDeclaredField("maxSubscriptionsPerTopic");
            field.setAccessible(true);
            Awaitility.await().until(() -> (Integer)field.get(persistentTopic) == 4);
            Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
            consumerList.add(consumer);
            Assert.assertEquals((int)consumerList.size(), (int)3);
            this.admin.namespaces().removeMaxSubscriptionsPerTopic(myNamespace);
            Awaitility.await().until(() -> field.get(persistentTopic) == null);
            try {
                client.newConsumer().topic(new String[]{topic}).subscriptionName(UUID.randomUUID().toString()).subscribe();
                Assert.fail((String)"should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Consumer c : consumerList) {
                c.close();
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testMaxProducersPerTopicUnlimited() throws Exception {
        boolean maxProducersPerTopic = true;
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
        this.conf.setMaxProducersPerTopic(1);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        String myNamespace = "prop-xyz/ns" + UUID.randomUUID();
        this.admin.namespaces().createNamespace(myNamespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://" + myNamespace + "/testMaxProducersPerTopicUnlimited";
        this.admin.namespaces().setMaxProducersPerTopic(myNamespace, 0);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxProducersPerTopic(myNamespace) == 0);
        ArrayList<Producer> producers = new ArrayList<Producer>();
        for (int i = 0; i < 2; ++i) {
            Producer producer = this.pulsarClient.newProducer().topic(topic).create();
            producers.add(producer);
        }
        this.admin.namespaces().removeMaxProducersPerTopic(myNamespace);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxProducersPerTopic(myNamespace) == null);
        try {
            this.pulsarClient.newProducer().topic(topic).create();
            Assert.fail((String)"should fail");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Topic reached max producers limit"));
        }
        this.admin.namespaces().setMaxProducersPerTopic(myNamespace, 3);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxProducersPerTopic(myNamespace) == 3);
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        producers.add(producer);
        try {
            this.pulsarClient.newProducer().topic(topic).create();
            Assert.fail((String)"should fail");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Topic reached max producers limit"));
        }
        for (Producer tempProducer : producers) {
            tempProducer.close();
        }
    }

    @Test
    public void testMaxConsumersPerTopicUnlimited() throws Exception {
        boolean maxConsumersPerTopic = true;
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
        this.conf.setMaxConsumersPerTopic(1);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        String myNamespace = "prop-xyz/ns" + UUID.randomUUID();
        this.admin.namespaces().createNamespace(myNamespace, (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        String topic = "persistent://" + myNamespace + "/testMaxConsumersPerTopicUnlimited";
        Assert.assertNull((Object)this.admin.namespaces().getMaxConsumersPerTopic(myNamespace));
        this.admin.namespaces().setMaxConsumersPerTopic(myNamespace, 0);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxConsumersPerTopic(myNamespace) == 0);
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (int i = 0; i < 2; ++i) {
            Consumer consumer = this.pulsarClient.newConsumer().subscriptionName(UUID.randomUUID().toString()).topic(new String[]{topic}).subscribe();
            consumers.add(consumer);
        }
        this.admin.namespaces().removeMaxConsumersPerTopic(myNamespace);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxConsumersPerTopic(myNamespace) == null);
        try {
            this.pulsarClient.newConsumer().subscriptionName(UUID.randomUUID().toString()).topic(new String[]{topic}).subscribe();
            Assert.fail((String)"should fail");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Topic reached max consumers limit"));
        }
        this.admin.namespaces().setMaxConsumersPerTopic(myNamespace, 3);
        Awaitility.await().until(() -> this.admin.namespaces().getMaxConsumersPerTopic(myNamespace) == 3);
        Consumer consumer = this.pulsarClient.newConsumer().subscriptionName(UUID.randomUUID().toString()).topic(new String[]{topic}).subscribe();
        consumers.add(consumer);
        try {
            this.pulsarClient.newConsumer().subscriptionName(UUID.randomUUID().toString()).topic(new String[]{topic}).subscribe();
            Assert.fail((String)"should fail");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Topic reached max consumers limit"));
        }
        for (Consumer subConsumer : consumers) {
            subConsumer.close();
        }
    }

    @Test
    public void testClearBacklogForTheSubscriptionThatNoConsumers() throws Exception {
        String topic = "persistent://prop-xyz/ns1/clear_backlog_no_consumers" + UUID.randomUUID().toString();
        String sub = "my-sub";
        this.admin.topics().createNonPartitionedTopic(topic);
        this.admin.topics().createSubscription(topic, "my-sub", MessageId.earliest);
        this.admin.topics().skipAllMessages(topic, "my-sub");
    }

    @Test(timeOut=200000L)
    public void testCompactionApi() throws Exception {
        String namespace = "prop-xyz/ns1";
        Assert.assertNull((Object)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1"));
        Assert.assertEquals((long)this.pulsar.getConfiguration().getBrokerServiceCompactionThresholdInBytes(), (long)0L);
        this.admin.namespaces().setCompactionThreshold("prop-xyz/ns1", 10L);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1")));
        Assert.assertEquals((int)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1").intValue(), (int)10);
        this.admin.namespaces().removeCompactionThreshold("prop-xyz/ns1");
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1")));
    }

    @Test(timeOut=200000L)
    public void testCompactionPriority() throws Exception {
        this.cleanup();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.conf.setBrokerServiceCompactionMonitorIntervalInSeconds(10000);
        this.setup();
        String topic = "persistent://prop-xyz/ns1/topic" + UUID.randomUUID();
        String namespace = "prop-xyz/ns1";
        this.pulsarClient.newProducer().topic(topic).create().close();
        TopicName topicName = TopicName.get((String)topic);
        Awaitility.await().until(() -> this.pulsar.getTopicPoliciesService().cacheIsInitialized(topicName));
        PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topic).get()).get();
        PersistentTopic mockTopic = (PersistentTopic)Mockito.spy((Object)persistentTopic);
        mockTopic.checkCompaction();
        ((PersistentTopic)Mockito.verify((Object)mockTopic, (VerificationMode)Mockito.times((int)0))).triggerCompaction();
        this.admin.namespaces().setCompactionThreshold("prop-xyz/ns1", 1L);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1")));
        ManagedLedger managedLedger = persistentTopic.getManagedLedger();
        Field field = managedLedger.getClass().getDeclaredField("totalSize");
        field.setAccessible(true);
        field.setLong(managedLedger, 1000L);
        mockTopic.checkCompaction();
        ((PersistentTopic)Mockito.verify((Object)mockTopic, (VerificationMode)Mockito.times((int)1))).triggerCompaction();
        this.admin.topics().setCompactionThreshold(topic, 0L);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getCompactionThreshold(topic)));
        mockTopic.checkCompaction();
        ((PersistentTopic)Mockito.verify((Object)mockTopic, (VerificationMode)Mockito.times((int)1))).triggerCompaction();
        this.admin.topics().removeCompactionThreshold(topic);
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.topics().getCompactionThreshold(topic)));
        mockTopic.checkCompaction();
        ((PersistentTopic)Mockito.verify((Object)mockTopic, (VerificationMode)Mockito.times((int)2))).triggerCompaction();
        this.admin.namespaces().removeCompactionThreshold("prop-xyz/ns1");
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getCompactionThreshold("prop-xyz/ns1")));
        mockTopic.checkCompaction();
        ((PersistentTopic)Mockito.verify((Object)mockTopic, (VerificationMode)Mockito.times((int)2))).triggerCompaction();
    }

    @Test
    public void testProperties() throws Exception {
        String namespace = "prop-xyz/ns1";
        this.admin.namespaces().setProperty("prop-xyz/ns1", "a", "a");
        Assert.assertEquals((String)"a", (String)this.admin.namespaces().getProperty("prop-xyz/ns1", "a"));
        Assert.assertNull((Object)this.admin.namespaces().getProperty("prop-xyz/ns1", "b"));
        this.admin.namespaces().setProperty("prop-xyz/ns1", "b", "b");
        Assert.assertEquals((String)"b", (String)this.admin.namespaces().getProperty("prop-xyz/ns1", "b"));
        this.admin.namespaces().setProperty("prop-xyz/ns1", "a", "a1");
        Assert.assertEquals((String)"a1", (String)this.admin.namespaces().getProperty("prop-xyz/ns1", "a"));
        Assert.assertEquals((String)"b", (String)this.admin.namespaces().removeProperty("prop-xyz/ns1", "b"));
        Assert.assertNull((Object)this.admin.namespaces().getProperty("prop-xyz/ns1", "b"));
        this.admin.namespaces().clearProperties("prop-xyz/ns1");
        Assert.assertEquals((int)this.admin.namespaces().getProperties("prop-xyz/ns1").size(), (int)0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("aaa", "aaa");
        properties.put("bbb", "bbb");
        this.admin.namespaces().setProperties("prop-xyz/ns1", properties);
        Assert.assertEquals((Map)this.admin.namespaces().getProperties("prop-xyz/ns1"), properties);
        this.admin.namespaces().clearProperties("prop-xyz/ns1");
        Assert.assertEquals((int)this.admin.namespaces().getProperties("prop-xyz/ns1").size(), (int)0);
    }

    @Test
    public void testGetListInBundle() throws Exception {
        String namespace = "prop-xyz/ns11";
        this.admin.namespaces().createNamespace("prop-xyz/ns11", 3);
        String persistentTopicName = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"prop-xyz/ns11"), (String)("get_topics_mode_" + UUID.randomUUID())).toString();
        String nonPersistentTopicName = TopicName.get((String)"non-persistent", (NamespaceName)NamespaceName.get((String)"prop-xyz/ns11"), (String)("get_topics_mode_" + UUID.randomUUID())).toString();
        this.admin.topics().createPartitionedTopic(persistentTopicName, 3);
        this.admin.topics().createPartitionedTopic(nonPersistentTopicName, 3);
        this.pulsarClient.newProducer().topic(persistentTopicName).create().close();
        this.pulsarClient.newProducer().topic(nonPersistentTopicName).create().close();
        BundlesData bundlesData = this.admin.namespaces().getBundles("prop-xyz/ns11");
        List boundaries = bundlesData.getBoundaries();
        int topicNum = 0;
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
            List topic = this.admin.topics().getListInBundle("prop-xyz/ns11", bundle);
            if (topic == null) continue;
            topicNum += topic.size();
            for (String s : topic) {
                Assert.assertFalse((boolean)TopicName.get((String)s).isPersistent());
            }
        }
        Assert.assertEquals((int)topicNum, (int)3);
    }

    @Test
    public void testGetTopicsWithDifferentMode() throws Exception {
        String namespace = "prop-xyz/ns1";
        String persistentTopicName = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"prop-xyz/ns1"), (String)("get_topics_mode_" + UUID.randomUUID().toString())).toString();
        String nonPersistentTopicName = TopicName.get((String)"non-persistent", (NamespaceName)NamespaceName.get((String)"prop-xyz/ns1"), (String)("get_topics_mode_" + UUID.randomUUID().toString())).toString();
        Producer producer1 = this.pulsarClient.newProducer().topic(persistentTopicName).create();
        Producer producer2 = this.pulsarClient.newProducer().topic(nonPersistentTopicName).create();
        ArrayList topics = new ArrayList(this.admin.topics().getList("prop-xyz/ns1"));
        Assert.assertEquals((int)topics.size(), (int)2);
        Assert.assertTrue((boolean)topics.contains(persistentTopicName));
        Assert.assertTrue((boolean)topics.contains(nonPersistentTopicName));
        topics.clear();
        topics.addAll(this.admin.topics().getList("prop-xyz/ns1", TopicDomain.persistent));
        Assert.assertEquals((int)topics.size(), (int)1);
        Assert.assertTrue((boolean)topics.contains(persistentTopicName));
        topics.clear();
        topics.addAll(this.admin.topics().getList("prop-xyz/ns1", TopicDomain.non_persistent));
        Assert.assertEquals((int)topics.size(), (int)1);
        Assert.assertTrue((boolean)topics.contains(nonPersistentTopicName));
        try {
            this.admin.topics().getList("prop-xyz/ns1", TopicDomain.getEnum((String)"none"));
            Assert.fail((String)"Should failed with invalid get topic mode.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid topic domain: 'none'");
        }
        producer1.close();
        producer2.close();
    }
}

