/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminTopicApiTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(AdminTopicApiTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeekMessages() throws Exception {
        PulsarClient newPulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).build();
        try {
            String topic = "persistent://my-property/my-ns/test-publish-timestamp";
            Consumer consumer = newPulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/test-publish-timestamp"}).subscriptionName("my-sub").subscribe();
            try {
                int numMessages = 5;
                Producer producer = newPulsarClient.newProducer().topic("persistent://my-property/my-ns/test-publish-timestamp").enableBatching(true).batchingMaxPublishDelay(3L, TimeUnit.SECONDS).batchingMaxMessages(5).create();
                try {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        producer.newMessage().value((Object)("value-" + i).getBytes(StandardCharsets.UTF_8)).sendAsync();
                    }
                    producer.flush();
                    for (i = 0; i < 5; ++i) {
                        Message msg = consumer.receive();
                        log.info("Received message '{}'.", (Object)new String((byte[])msg.getValue(), StandardCharsets.UTF_8));
                    }
                    List messages = this.admin.topics().peekMessages("persistent://my-property/my-ns/test-publish-timestamp", "my-sub", 5);
                    Assert.assertEquals((String)new String((byte[])((Message)messages.get(0)).getValue(), StandardCharsets.UTF_8), (String)"value-0");
                    Assert.assertEquals((String)new String((byte[])((Message)messages.get(1)).getValue(), StandardCharsets.UTF_8), (String)"value-1");
                    Assert.assertEquals((String)new String((byte[])((Message)messages.get(2)).getValue(), StandardCharsets.UTF_8), (String)"value-2");
                    Assert.assertEquals((String)new String((byte[])((Message)messages.get(3)).getValue(), StandardCharsets.UTF_8), (String)"value-3");
                    Assert.assertEquals((String)new String((byte[])((Message)messages.get(4)).getValue(), StandardCharsets.UTF_8), (String)"value-4");
                }
                finally {
                    if (Collections.singletonList(producer).get(0) != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(newPulsarClient).get(0) != null) {
                newPulsarClient.close();
            }
        }
    }
}

