/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.util.List;
import java.util.UUID;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TopicAutoCreationTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setAllowAutoTopicCreationType("partitioned");
        this.conf.setAllowAutoTopicCreation(true);
        this.conf.setDefaultNumPartitions(3);
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testPartitionedTopicAutoCreation() throws PulsarAdminException, PulsarClientException {
        String namespaceName = "my-property/my-ns";
        String topic = "persistent://my-property/my-ns/test-partitioned-topi-auto-creation-" + UUID.randomUUID().toString();
        Producer producer = this.pulsarClient.newProducer().topic(topic).create();
        List partitionedTopics = this.admin.topics().getPartitionedTopicList("my-property/my-ns");
        List topics = this.admin.topics().getList("my-property/my-ns");
        Assert.assertEquals((int)partitionedTopics.size(), (int)1);
        Assert.assertEquals((int)topics.size(), (int)3);
        producer.close();
        for (String t : topics) {
            this.admin.topics().delete(t);
        }
        this.admin.topics().deletePartitionedTopic(topic);
        String partition = "persistent://my-property/my-ns/test-partitioned-topi-auto-creation-partition-0";
        producer = this.pulsarClient.newProducer().topic("persistent://my-property/my-ns/test-partitioned-topi-auto-creation-partition-0").create();
        partitionedTopics = this.admin.topics().getPartitionedTopicList("my-property/my-ns");
        topics = this.admin.topics().getList("my-property/my-ns");
        Assert.assertEquals((int)partitionedTopics.size(), (int)0);
        Assert.assertEquals((int)topics.size(), (int)1);
        producer.close();
    }
}

