/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(MockAuthentication.class);
    private final String user;

    public MockAuthentication(String user) {
        this.user = user;
    }

    public void close() {
    }

    public String getAuthMethodName() {
        return "mock";
    }

    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        return new AuthenticationDataProvider(){

            public boolean hasDataForHttp() {
                return true;
            }

            public String getHttpAuthType() {
                return "mock";
            }

            public Set<Map.Entry<String, String>> getHttpHeaders() {
                return ImmutableMap.of((Object)"mockuser", (Object)MockAuthentication.this.user).entrySet();
            }

            public boolean hasDataFromCommand() {
                return true;
            }

            public String getCommandData() {
                return MockAuthentication.this.user;
            }
        };
    }

    public void configure(Map<String, String> authParams) {
    }

    public void start() throws PulsarClientException {
    }

    public void authenticationStage(String requestUrl, AuthenticationDataProvider authData, Map<String, String> previousResHeaders, CompletableFuture<Map<String, String>> authFuture) {
        authFuture.complete(null);
    }
}

