/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(MockAuthorizationProvider.class);

    public void close() {
    }

    public CompletableFuture<Boolean> isSuperUser(String role, AuthenticationDataSource authenticationData, ServiceConfiguration serviceConfiguration) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> isSuperUser(String role, ServiceConfiguration serviceConfiguration) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.roleAuthorizedAsync(role);
    }

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authDataJson) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> grantPermissionAsync(TopicName topicName, Set<AuthAction> actions, String role, String authDataJson) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String originalRole, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowTenantOperation(String tenantName, String originalRole, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowTenantOperation(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowNamespaceOperation(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String originalRole, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowNamespaceOperation(NamespaceName namespaceName, String originalRole, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowTopicOperation(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String originalRole, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorizedAsync(role);
    }

    public Boolean allowTopicOperation(TopicName topicName, String originalRole, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.roleAuthorized(role);
    }

    CompletableFuture<Boolean> roleAuthorizedAsync(String role) {
        CompletableFuture<Boolean> promise = new CompletableFuture<Boolean>();
        try {
            promise.complete(this.roleAuthorized(role));
        }
        catch (Exception e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    boolean roleAuthorized(String role) {
        String[] parts = role.split("\\.");
        if (parts.length == 2) {
            switch (parts[1]) {
                case "pass": {
                    return true;
                }
                case "fail": {
                    return false;
                }
                case "error": {
                    throw new RuntimeException("Error in authn");
                }
            }
        }
        throw new IllegalArgumentException("Not a valid principle. Should be [pass|fail|error].[pass|fail|error], found " + role);
    }
}

