/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.loadbalance.impl.LinuxBrokerHostUsageImpl;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class LoadReportNetworkLimitTest
extends MockedPulsarServiceBaseTest {
    int nicCount;

    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setLoadBalancerOverrideBrokerNicSpeedGbps(Double.valueOf(5.4));
        super.internalSetup();
        if (SystemUtils.IS_OS_LINUX) {
            this.nicCount = new LinuxBrokerHostUsageImpl(this.pulsar).getNicCount();
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void checkLoadReportNicSpeed() throws Exception {
        LoadManagerReport report = this.admin.brokerStats().getLoadReport();
        if (SystemUtils.IS_OS_LINUX) {
            Assert.assertEquals((double)report.getBandwidthIn().limit, (double)((double)this.nicCount * 5.4 * 1024.0 * 1024.0));
            Assert.assertEquals((double)report.getBandwidthOut().limit, (double)((double)this.nicCount * 5.4 * 1024.0 * 1024.0));
        } else {
            Assert.assertEquals((double)report.getBandwidthIn().limit, (double)-1.0);
            Assert.assertEquals((double)report.getBandwidthOut().limit, (double)-1.0);
        }
    }
}

