/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Producer;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class NamespaceUnloadingTest
extends BrokerTestBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testUnloadNotLoadedNamespace() throws Exception {
        this.admin.namespaces().createNamespace("prop/ns-test-1");
        this.admin.namespaces().setNamespaceReplicationClusters("prop/ns-test-1", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Assert.assertTrue((boolean)this.admin.namespaces().getNamespaces("prop").contains("prop/ns-test-1"));
        this.admin.namespaces().unload("prop/ns-test-1");
    }

    @Test
    public void testUnloadPartiallyLoadedNamespace() throws Exception {
        this.admin.namespaces().createNamespace("prop/ns-test-2", 16);
        this.admin.namespaces().setNamespaceReplicationClusters("prop/ns-test-2", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop/ns-test-2/my-topic").create();
        Assert.assertTrue((boolean)this.admin.namespaces().getNamespaces("prop").contains("prop/ns-test-2"));
        this.admin.namespaces().unload("prop/ns-test-2");
        producer.close();
    }
}

