/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageConsumer;
import org.apache.pulsar.broker.resourcegroup.ResourceUsagePublisher;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTopicTransportManager;
import org.apache.pulsar.broker.service.resource.usage.NetworkUsage;
import org.apache.pulsar.broker.service.resource.usage.ResourceUsage;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceUsageTransportManagerTest
extends MockedPulsarServiceBaseTest {
    private static final int PUBLISH_INTERVAL_SECS = 1;
    ResourceUsageTopicTransportManager tManager;

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.prepareData();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.tManager.close();
        super.internalCleanup();
    }

    @Test
    public void testNamespaceCreation() throws Exception {
        TopicName topicName = TopicName.get((String)"non-persistent://pulsar/system/resource-usage");
        Assert.assertTrue((boolean)this.admin.tenants().getTenants().contains(topicName.getTenant()));
        Assert.assertTrue((boolean)this.admin.namespaces().getNamespaces(topicName.getTenant()).contains(topicName.getNamespace()));
    }

    @Test
    public void testPublish() throws Exception {
        final ResourceUsage recvdUsage = new ResourceUsage();
        final String[] recvdBroker = new String[1];
        ResourceUsagePublisher p = new ResourceUsagePublisher(){

            public String getID() {
                return "resource-group1";
            }

            public void fillResourceUsage(ResourceUsage resourceUsage) {
                resourceUsage.setOwner(this.getID());
                resourceUsage.setPublish().setMessagesPerPeriod(1000L).setBytesPerPeriod(10001L);
                resourceUsage.setStorage().setTotalBytes(500003L);
            }
        };
        ResourceUsageConsumer c = new ResourceUsageConsumer(){

            public String getID() {
                return "resource-group1";
            }

            public void acceptResourceUsage(String broker, ResourceUsage resourceUsage) {
                recvdBroker[0] = broker;
                recvdUsage.setOwner(resourceUsage.getOwner());
                NetworkUsage p = recvdUsage.setPublish();
                p.setBytesPerPeriod(resourceUsage.getPublish().getBytesPerPeriod());
                p.setMessagesPerPeriod(resourceUsage.getPublish().getMessagesPerPeriod());
                recvdUsage.setStorage().setTotalBytes(resourceUsage.getStorage().getTotalBytes());
            }
        };
        this.tManager.registerResourceUsagePublisher(p);
        this.tManager.registerResourceUsageConsumer(c);
        Thread.sleep(2000L);
        Assert.assertEquals((String)recvdBroker[0], (String)this.pulsar.getBrokerServiceUrl());
        Assert.assertNotNull((Object)recvdUsage.getPublish());
        Assert.assertNotNull((Object)recvdUsage.getStorage());
        Assert.assertEquals((long)recvdUsage.getPublish().getBytesPerPeriod(), (long)10001L);
        Assert.assertEquals((long)recvdUsage.getStorage().getTotalBytes(), (long)500003L);
    }

    private void prepareData() throws PulsarServerException, PulsarAdminException, PulsarClientException {
        this.conf.setResourceUsageTransportClassName("org.apache.pulsar.broker.resourcegroup.ResourceUsageTopicTransportManager");
        this.conf.setResourceUsageTransportPublishIntervalInSecs(1);
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.tManager = new ResourceUsageTopicTransportManager(this.pulsar);
    }
}

