/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerServiceAutoSubscriptionCreationTest
extends BrokerTestBase {
    private final AtomicInteger testId = new AtomicInteger(0);

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanupTest() throws Exception {
        this.pulsar.getAdminClient().namespaces().removeAutoSubscriptionCreation("prop/ns-abc");
    }

    @Test
    public void testAutoSubscriptionCreationDisable() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoSubscriptionCreation(false);
        String topicName = "persistent://prop/ns-abc/test-subtopic-" + this.testId.getAndIncrement();
        String subscriptionName = "test-subtopic-sub";
        this.admin.topics().createNonPartitionedTopic(topicName);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("test-subtopic-sub").subscribe();
            Assert.fail((String)"Subscribe operation should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
        Assert.assertFalse((boolean)this.admin.topics().getSubscriptions(topicName).contains("test-subtopic-sub"));
    }

    @Test
    public void testSubscriptionCreationWithAutoCreationDisable() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoSubscriptionCreation(false);
        String topicName = "persistent://prop/ns-abc/test-subtopic-" + this.testId.getAndIncrement();
        String subscriptionName = "test-subtopic-sub-1";
        this.admin.topics().createNonPartitionedTopic(topicName);
        Assert.assertFalse((boolean)this.admin.topics().getSubscriptions(topicName).contains("test-subtopic-sub-1"));
        this.admin.topics().createSubscription(topicName, "test-subtopic-sub-1", MessageId.earliest);
        Assert.assertTrue((boolean)this.admin.topics().getSubscriptions(topicName).contains("test-subtopic-sub-1"));
        this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("test-subtopic-sub-1").subscribe();
    }

    @Test
    public void testAutoSubscriptionCreationNamespaceAllowOverridesBroker() throws Exception {
        String topic = "persistent://prop/ns-abc/test-subtopic-" + this.testId.getAndIncrement();
        String subscriptionName = "test-subtopic-sub-2";
        TopicName topicName = TopicName.get((String)topic);
        this.admin.topics().createNonPartitionedTopic(topicName.toString());
        this.pulsar.getConfiguration().setAllowAutoSubscriptionCreation(false);
        this.pulsar.getAdminClient().namespaces().setAutoSubscriptionCreation(topicName.getNamespace(), AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(true).build());
        this.pulsarClient.newConsumer().topic(new String[]{topicName.toString()}).subscriptionName("test-subtopic-sub-2").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getSubscriptions(topicName.toString()).contains("test-subtopic-sub-2"));
    }

    @Test
    public void testAutoSubscriptionCreationNamespaceDisallowOverridesBroker() throws Exception {
        String topic = "persistent://prop/ns-abc/test-subtopic-" + this.testId.getAndIncrement();
        String subscriptionName = "test-subtopic-sub-3";
        TopicName topicName = TopicName.get((String)topic);
        this.admin.topics().createNonPartitionedTopic(topicName.toString());
        this.pulsar.getConfiguration().setAllowAutoSubscriptionCreation(true);
        this.pulsar.getAdminClient().namespaces().setAutoSubscriptionCreation(topicName.getNamespace(), AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(false).build());
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topicName.toString()}).subscriptionName("test-subtopic-sub-3").subscribe();
            Assert.fail((String)"Subscribe operation should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
        Assert.assertFalse((boolean)this.admin.topics().getSubscriptions(topicName.toString()).contains("test-subtopic-sub-3"));
    }
}

