/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class HashRangeAutoSplitStickyKeyConsumerSelectorTest {
    @Test
    public void testGetConsumerKeyHashRanges() throws BrokerServiceException.ConsumerAssignException {
        HashRangeAutoSplitStickyKeyConsumerSelector selector = new HashRangeAutoSplitStickyKeyConsumerSelector(64);
        List<String> consumerName = Arrays.asList("consumer1", "consumer2", "consumer3", "consumer4");
        for (String s : consumerName) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)s);
            selector.addConsumer(consumer);
        }
        HashMap<String, ImmutableList> expectedResult = new HashMap<String, ImmutableList>();
        expectedResult.put("consumer1", ImmutableList.of((Object)"[49, 64]"));
        expectedResult.put("consumer4", ImmutableList.of((Object)"[33, 48]"));
        expectedResult.put("consumer2", ImmutableList.of((Object)"[17, 32]"));
        expectedResult.put("consumer3", ImmutableList.of((Object)"[0, 16]"));
        for (Map.Entry entry : selector.getConsumerKeyHashRanges().entrySet()) {
            Assert.assertEquals((Collection)((Collection)entry.getValue()), (Collection)((Collection)expectedResult.get(entry.getKey())));
            expectedResult.remove(entry.getKey());
        }
        Assert.assertEquals((int)expectedResult.size(), (int)0);
    }
}

