/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.JsonSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.KeyValueSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class KeyValueSchemaCompatibilityCheckTest {
    private final Map<SchemaType, SchemaCompatibilityCheck> checkers = Maps.newHashMap();

    @BeforeClass
    protected void setup() {
        this.checkers.put(SchemaType.AVRO, (SchemaCompatibilityCheck)new AvroSchemaCompatibilityCheck());
        this.checkers.put(SchemaType.JSON, (SchemaCompatibilityCheck)new JsonSchemaCompatibilityCheck());
        this.checkers.put(SchemaType.KEY_VALUE, (SchemaCompatibilityCheck)new KeyValueSchemaCompatibilityCheck(this.checkers));
    }

    @Test
    public void testCheckKeyValueAvroCompatibilityFull() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyValueAvroInCompatibilityFull() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyValueAvroCompatibilityBackward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyValueAvroInCompatibilityBackward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyValueAvroCompatibilityForward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyValueAvroInCompatibilityForward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyValueJsonCompatibilityFull() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyValueJsonInCompatibilityFull() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyValueJsonCompatibilityBackward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyValueJsonInCompatibilityBackWard() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyValueJsonCompatibilityForward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyValueJsonInCompatibilityForward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyAvroValueJsonCompatibilityFull() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyAvroValueJsonInCompatibilityFull() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyAvroValueJsonCompatibilityBackward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyAvroValueJsonInCompatibilityBackward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyAvroValueJsonCompatibilityForward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyAvroValueJsonInCompatibilityForward() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        JSONSchema barSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        properties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroCompatibilityFull() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyJsonValueAvroInCompatibilityFull() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckKeyJsonValueAvroCompatibilityBackward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroInCompatibilityBackward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.BACKWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroCompatibilityForward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroInCompatibilityForward() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap properties = Maps.newHashMap();
        properties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        properties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)properties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroKeyTypeInCompatibility() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap fromProperties = Maps.newHashMap();
        fromProperties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        fromProperties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        HashMap toProperties = Maps.newHashMap();
        toProperties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        toProperties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)fromProperties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)barSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)toProperties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckKeyJsonValueAvroValueTypeInCompatibility() {
        JSONSchema fooSchema = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap fromProperties = Maps.newHashMap();
        fromProperties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        fromProperties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        HashMap toProperties = Maps.newHashMap();
        toProperties.put("key.schema.type", String.valueOf(SchemaType.JSON));
        toProperties.put("value.schema.type", String.valueOf(SchemaType.JSON));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)fromProperties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)fooSchema).getSchemaInfo().getSchema()).props((Map)toProperties).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FORWARD));
    }

    @Test
    public void testCheckPropertiesNullTypeCompatibility() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap fromProperties = Maps.newHashMap();
        fromProperties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        fromProperties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        HashMap toProperties = Maps.newHashMap();
        toProperties.put("key.schema.type", String.valueOf(SchemaType.AVRO));
        toProperties.put("value.schema.type", String.valueOf(SchemaType.AVRO));
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)fromProperties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)toProperties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckSchemaTypeNullCompatibility() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        HashMap fromProperties = Maps.newHashMap();
        HashMap toProperties = Maps.newHashMap();
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)fromProperties).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).props((Map)toProperties).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.FULL));
    }

    @Test
    public void testCheckSchemaTypeAlwaysCompatibility() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        StringSchema stringSchema = new StringSchema();
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.STRING).data(stringSchema.getSchemaInfo().getSchema()).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).build();
        Assert.assertTrue((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.ALWAYS_COMPATIBLE));
    }

    @Test
    public void testCheckSchemaTypeOtherCompatibility() {
        AvroSchema fooSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build());
        AvroSchema barSchema = AvroSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Bar.class).build());
        StringSchema stringSchema = new StringSchema();
        SchemaData fromSchemaData = SchemaData.builder().type(SchemaType.STRING).data(stringSchema.getSchemaInfo().getSchema()).build();
        SchemaData toSchemaData = SchemaData.builder().type(SchemaType.KEY_VALUE).data(KeyValueSchemaImpl.of((Schema)fooSchema, (Schema)barSchema).getSchemaInfo().getSchema()).build();
        Assert.assertFalse((boolean)this.checkers.get(SchemaType.KEY_VALUE).isCompatible(fromSchemaData, toSchemaData, SchemaCompatibilityStrategy.ALWAYS_INCOMPATIBLE));
    }

    private static class Bar {
        private boolean field1;

        public boolean isField1() {
            return this.field1;
        }

        public void setField1(boolean field1) {
            this.field1 = field1;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bar)) {
                return false;
            }
            Bar other = (Bar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isField1() == other.isField1();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Bar;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isField1() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "KeyValueSchemaCompatibilityCheckTest.Bar(field1=" + this.isField1() + ")";
        }
    }

    private static class Foo {
        private String field1;
        private String field2;
        private int field3;
        private Bar field4;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public int getField3() {
            return this.field3;
        }

        public Bar getField4() {
            return this.field4;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public void setField4(Bar field4) {
            this.field4 = field4;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getField3() != other.getField3()) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            if (this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2)) {
                return false;
            }
            Bar this$field4 = this.getField4();
            Bar other$field4 = other.getField4();
            return !(this$field4 == null ? other$field4 != null : !((Object)this$field4).equals(other$field4));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getField3();
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            Bar $field4 = this.getField4();
            result = result * 59 + ($field4 == null ? 43 : ((Object)$field4).hashCode());
            return result;
        }

        public String toString() {
            return "KeyValueSchemaCompatibilityCheckTest.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ", field4=" + this.getField4() + ")";
        }
    }
}

