/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.PulsarMockLedgerHandle;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.stats.Metrics;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"quarantine"})
public class ManagedCursorMetricsTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass(alwaysRun=true)
    protected void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    public void testManagedCursorMetrics() throws Exception {
        String subName = "my-sub";
        String topicName = "persistent://my-namespace/use/my-ns/my-topic1";
        int messageSize = 10;
        ManagedCursorMetrics metrics = new ManagedCursorMetrics(this.pulsar);
        List metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        metricsList = metrics.generate();
        Assert.assertTrue((boolean)metricsList.isEmpty());
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-namespace/use/my-ns/my-topic1"}).subscriptionType(SubscriptionType.Shared).ackTimeout(1L, TimeUnit.SECONDS).subscriptionName("my-sub").subscribe();
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-namespace/use/my-ns/my-topic1").create();
        for (PulsarMockLedgerHandle ledgerHandle : this.mockBookKeeper.getLedgerMap().values()) {
            ledgerHandle.close();
        }
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
            consumer.acknowledge(consumer.receive().getMessageId());
        }
        metricsList = metrics.generate();
        Assert.assertFalse((boolean)metricsList.isEmpty());
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistLedgerSucceed"), (Object)0L);
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistLedgerErrors"), (Object)0L);
        Assert.assertNotEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistZookeeperSucceed"), (Object)0L);
        Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_persistZookeeperErrors"), (Object)0L);
        Assert.assertEquals(((Metrics)metricsList.get(0)).getMetrics().get("brk_ml_cursor_nonContiguousDeletedMessagesRange"), (Object)0L);
    }
}

