/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionLogImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ManagedLedgerMetricsTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testManagedLedgerMetrics() throws Exception {
        ManagedLedgerMetrics metrics = new ManagedLedgerMetrics(this.pulsar);
        String addEntryRateKey = "brk_ml_AddEntryMessagesRate";
        List list1 = metrics.generate();
        Assert.assertTrue((boolean)list1.isEmpty());
        Producer producer = this.pulsarClient.newProducer().topic("persistent://my-property/use/my-ns/my-topic1").create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        for (Map.Entry ledger : ((ManagedLedgerFactoryImpl)this.pulsar.getManagedLedgerFactory()).getManagedLedgers().entrySet()) {
            ManagedLedgerMBeanImpl stats = (ManagedLedgerMBeanImpl)((ManagedLedgerImpl)ledger.getValue()).getStats();
            stats.refreshStats(1L, TimeUnit.SECONDS);
        }
        List list2 = metrics.generate();
        Assert.assertEquals(((Metrics)list2.get(0)).getMetrics().get("brk_ml_AddEntryMessagesRate"), (Object)10.0);
        for (int i = 0; i < 5; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        for (Map.Entry ledger : ((ManagedLedgerFactoryImpl)this.pulsar.getManagedLedgerFactory()).getManagedLedgers().entrySet()) {
            ManagedLedgerMBeanImpl stats = (ManagedLedgerMBeanImpl)((ManagedLedgerImpl)ledger.getValue()).getStats();
            stats.refreshStats(1L, TimeUnit.SECONDS);
        }
        List list3 = metrics.generate();
        Assert.assertEquals(((Metrics)list3.get(0)).getMetrics().get("brk_ml_AddEntryMessagesRate"), (Object)5.0);
    }

    @Test
    public void testTransactionTopic() throws Exception {
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
        ManagedLedgerConfig managedLedgerConfig = new ManagedLedgerConfig();
        managedLedgerConfig.setMaxEntriesPerLedger(2);
        new MLTransactionLogImpl(TransactionCoordinatorID.get((long)0L), this.pulsar.getManagedLedgerFactory(), managedLedgerConfig).initialize().join();
        ManagedLedgerMetrics metrics = new ManagedLedgerMetrics(this.pulsar);
        metrics.generate();
    }
}

