/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransactionClientReconnectTest
extends TransactionTestBase {
    private static final String RECONNECT_TOPIC = "persistent://public/txn/txn-client-reconnect-test";

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.setBrokerCount(1);
        super.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant("public", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("public/txn", 10);
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createNonPartitionedTopic(RECONNECT_TOPIC);
        this.admin.topics().createSubscription(RECONNECT_TOPIC, "test", MessageId.latest);
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    @Test
    public void testTransactionClientReconnectTest() throws PulsarClientException, ExecutionException, InterruptedException {
        ((PulsarClientImpl)this.pulsarClient).getLookup().getPartitionedTopicMetadata(TopicName.TRANSACTION_COORDINATOR_ASSIGN).get();
        Awaitility.await().until(() -> {
            this.pulsarClient.newTransaction().withTransactionTimeout(200L, TimeUnit.MILLISECONDS).build().get();
            return true;
        });
        TransactionImpl transaction = (TransactionImpl)this.pulsarClient.newTransaction().withTransactionTimeout(200L, TimeUnit.MILLISECONDS).build().get();
        TransactionMetadataStoreService transactionMetadataStoreService = this.getPulsarServiceList().get(0).getTransactionMetadataStoreService();
        transactionMetadataStoreService.removeTransactionMetadataStore(TransactionCoordinatorID.get((long)0L));
        try {
            this.pulsarClient.newTransaction().withTransactionTimeout(200L, TimeUnit.MILLISECONDS).build().get();
            FileAssert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCoordinatorClientException.CoordinatorNotFoundException));
        }
        try {
            transaction.registerProducedTopic(RECONNECT_TOPIC).get();
            FileAssert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCoordinatorClientException.MetaStoreHandlerNotReadyException));
        }
        try {
            transaction.registerAckedTopic(RECONNECT_TOPIC, "test").get();
            FileAssert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCoordinatorClientException.MetaStoreHandlerNotReadyException));
        }
        try {
            transaction.commit().get();
            FileAssert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TransactionCoordinatorClientException.MetaStoreHandlerNotReadyException));
        }
        transactionMetadataStoreService.addTransactionMetadataStore(TransactionCoordinatorID.get((long)0L));
        Awaitility.await().until(() -> {
            this.pulsarClient.newTransaction().withTransactionTimeout(200L, TimeUnit.MILLISECONDS).build().get();
            return true;
        });
        transaction = (TransactionImpl)this.pulsarClient.newTransaction().withTransactionTimeout(200L, TimeUnit.MILLISECONDS).build().get();
        transaction.registerProducedTopic(RECONNECT_TOPIC).get();
        transaction.registerAckedTopic(RECONNECT_TOPIC, "test").get();
        transaction.commit().get();
    }
}

