/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.web.ProcessHandlerFilter;
import org.mockito.Mockito;
import org.testng.annotations.Test;
import org.testng.collections.Sets;

public class ProcessHandlerFilterTest {
    @Test
    public void testInterceptorOnFilter() throws ServletException, IOException {
        PulsarService mockPulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        BrokerInterceptor spyInterceptor = (BrokerInterceptor)Mockito.spy(BrokerInterceptor.class);
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServiceConfiguration mockConfig = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        FilterChain mockFilterChain = (FilterChain)Mockito.mock(FilterChain.class);
        ((PulsarService)Mockito.doReturn((Object)spyInterceptor).when((Object)mockPulsarService)).getBrokerInterceptor();
        ((PulsarService)Mockito.doReturn((Object)mockConfig).when((Object)mockPulsarService)).getConfig();
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet((Object[])new String[]{"Interceptor1", "Interceptor2"})).when((Object)mockConfig)).getBrokerInterceptors();
        ProcessHandlerFilter processHandlerFilter = new ProcessHandlerFilter(mockPulsarService);
        processHandlerFilter.doFilter((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse, mockFilterChain);
        ((BrokerInterceptor)Mockito.verify((Object)spyInterceptor)).onFilter((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse, mockFilterChain);
    }

    @Test
    public void testChainDoFilter() throws ServletException, IOException {
        PulsarService mockPulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        BrokerInterceptor spyInterceptor = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ServiceConfiguration mockConfig = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        FilterChain spyFilterChain = (FilterChain)Mockito.spy(FilterChain.class);
        ((PulsarService)Mockito.doReturn((Object)spyInterceptor).when((Object)mockPulsarService)).getBrokerInterceptor();
        ((PulsarService)Mockito.doReturn((Object)mockConfig).when((Object)mockPulsarService)).getConfig();
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet()).when((Object)mockConfig)).getBrokerInterceptors();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ProcessHandlerFilter processHandlerFilter = new ProcessHandlerFilter(mockPulsarService);
        processHandlerFilter.doFilter((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse, spyFilterChain);
        ((FilterChain)Mockito.verify((Object)spyFilterChain)).doFilter((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse);
        Mockito.clearInvocations((Object[])new FilterChain[]{spyFilterChain});
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet((Object[])new String[]{"Interceptor1", "Interceptor2"})).when((Object)mockConfig)).getBrokerInterceptors();
        HttpServletRequest mockHttpServletRequest2 = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((HttpServletRequest)Mockito.doReturn((Object)"multipart/form-data").when((Object)mockHttpServletRequest2)).getContentType();
        ProcessHandlerFilter processHandlerFilter2 = new ProcessHandlerFilter(mockPulsarService);
        processHandlerFilter2.doFilter((ServletRequest)mockHttpServletRequest2, (ServletResponse)mockHttpServletResponse, spyFilterChain);
        ((FilterChain)Mockito.verify((Object)spyFilterChain)).doFilter((ServletRequest)mockHttpServletRequest2, (ServletResponse)mockHttpServletResponse);
        Mockito.clearInvocations((Object[])new FilterChain[]{spyFilterChain});
        ((HttpServletRequest)Mockito.doReturn((Object)"application/octet-stream").when((Object)mockHttpServletRequest2)).getContentType();
        processHandlerFilter2.doFilter((ServletRequest)mockHttpServletRequest2, (ServletResponse)mockHttpServletResponse, spyFilterChain);
        ((FilterChain)Mockito.verify((Object)spyFilterChain)).doFilter((ServletRequest)mockHttpServletRequest2, (ServletResponse)mockHttpServletResponse);
    }
}

