/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.v1;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public abstract class V1_ProducerConsumerBase
extends MockedPulsarServiceBaseTest {
    protected String methodName;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method m) throws Exception {
        this.methodName = m.getName();
    }

    public void producerBaseSetup() throws Exception {
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace("my-property/use/my-ns");
    }

    protected void testMessageOrderAndDuplicates(Set<String> messagesReceived, String receivedMessage, String expectedMessage) {
        Assert.assertEquals((String)receivedMessage, (String)expectedMessage, (String)("Received message " + receivedMessage + " did not match the expected message " + expectedMessage));
        Assert.assertTrue((boolean)messagesReceived.add(receivedMessage), (String)("Received duplicate message " + receivedMessage));
    }
}

