/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class SchemaDeleteTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.conf.setBrokerDeleteInactiveTopicsFrequencySeconds(5);
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.tenants().createTenant("my-property", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-property/my-ns", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void createTopicDeleteTopicCreateTopic() throws Exception {
        String namespace = "my-property/my-ns";
        String topic = namespace + "/topic1";
        String foobar = "foo";
        try (Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();){
            producer.send((Object)foobar);
        }
        this.admin.topics().delete(topic);
        this.admin.schemas().deleteSchema(topic);
        Reader reader = this.pulsarClient.newReader(Schema.STRING).topic(topic).startMessageId(MessageId.latest).create();
        var5_5 = null;
        if (reader != null) {
            if (var5_5 != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    var5_5.addSuppressed(throwable);
                }
            } else {
                reader.close();
            }
        }
        this.admin.namespaces().setSchemaAutoUpdateCompatibilityStrategy(namespace, SchemaAutoUpdateCompatibilityStrategy.BackwardTransitive);
        this.admin.topics().delete(topic);
        this.admin.schemas().deleteSchema(topic);
        reader = this.pulsarClient.newReader(Schema.AVRO(DummyPojo.class)).topic(topic).startMessageId(MessageId.latest).create();
        var5_5 = null;
        if (reader != null) {
            if (var5_5 != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    var5_5.addSuppressed(throwable);
                }
            } else {
                reader.close();
            }
        }
    }

    public static class DummyPojo {
        int foobar;
    }
}

