/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.util.HashedWheelTimer;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class TopicDoesNotExistsTest
extends ProducerConsumerBase {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setAllowAutoTopicCreation(false);
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testCreateProducerOnNotExistsTopic() throws PulsarClientException, InterruptedException {
        PulsarClient pulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).build();
        try {
            try {
                pulsarClient.newProducer().topic("persistent://public/default/" + UUID.randomUUID().toString()).sendTimeout(100, TimeUnit.MILLISECONDS).create();
                Assert.fail((String)"Create producer should failed while topic does not exists.");
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
            Thread.sleep(2000L);
            HashedWheelTimer timer = (HashedWheelTimer)((PulsarClientImpl)pulsarClient).timer();
            Assert.assertEquals((long)timer.pendingTimeouts(), (long)0L);
            Assert.assertEquals((int)((PulsarClientImpl)pulsarClient).producersCount(), (int)0);
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }

    @Test
    public void testCreateConsumerOnNotExistsTopic() throws PulsarClientException, InterruptedException {
        PulsarClient pulsarClient = this.newPulsarClient(this.lookupUrl.toString(), 1);
        try {
            try {
                pulsarClient.newConsumer().topic(new String[]{"persistent://public/default/" + UUID.randomUUID().toString()}).subscriptionName("test").subscribe();
                Assert.fail((String)"Create consumer should failed while topic does not exists.");
            }
            catch (PulsarClientException pulsarClientException) {
                // empty catch block
            }
            Thread.sleep(2000L);
            HashedWheelTimer timer = (HashedWheelTimer)((PulsarClientImpl)pulsarClient).timer();
            Assert.assertEquals((long)timer.pendingTimeouts(), (long)0L);
            Assert.assertEquals((int)((PulsarClientImpl)pulsarClient).consumersCount(), (int)0);
        }
        finally {
            if (Collections.singletonList(pulsarClient).get(0) != null) {
                pulsarClient.close();
            }
        }
    }
}

