/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-naming"})
public class NamespaceBundlesTest {
    private NamespaceBundleFactory factory;
    private static final Logger log = LoggerFactory.getLogger(NamespaceBundlesTest.class);

    @BeforeMethod(alwaysRun=true)
    protected void initializeFactory() {
        this.factory = this.getNamespaceBundleFactory();
    }

    @Test
    public void testConstructor() throws Exception {
        long[] partitions = new long[]{0L, 0x10000000L, 0x40000000L, 0xFFFFFFFFL};
        NamespaceBundles bundles = new NamespaceBundles(NamespaceName.get((String)"pulsar/use/ns2"), this.factory, Optional.empty(), partitions);
        Field partitionField = NamespaceBundles.class.getDeclaredField("partitions");
        Field nsField = NamespaceBundles.class.getDeclaredField("nsname");
        Field bundlesField = NamespaceBundles.class.getDeclaredField("bundles");
        partitionField.setAccessible(true);
        nsField.setAccessible(true);
        bundlesField.setAccessible(true);
        long[] partFld = (long[])partitionField.get(bundles);
        Assert.assertEquals((int)partitions.length, (int)partFld.length);
        NamespaceName nsFld = (NamespaceName)nsField.get(bundles);
        Assert.assertEquals((String)nsFld.toString(), (String)"pulsar/use/ns2");
        ArrayList bundleList = (ArrayList)bundlesField.get(bundles);
        Assert.assertEquals((int)bundleList.size(), (int)3);
        Assert.assertEquals(bundleList.get(0), (Object)this.factory.getBundle(nsFld, Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.OPEN)));
        Assert.assertEquals(bundleList.get(1), (Object)this.factory.getBundle(nsFld, Range.range((Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN)));
        Assert.assertEquals(bundleList.get(2), (Object)this.factory.getBundle(nsFld, Range.range((Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0xFFFFFFFFL), (BoundType)BoundType.CLOSED)));
    }

    private NamespaceBundleFactory getNamespaceBundleFactory() {
        PulsarService pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        LocalZooKeeperCacheService localZkCache = (LocalZooKeeperCacheService)Mockito.mock(LocalZooKeeperCacheService.class);
        ZooKeeperDataCache poilciesCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        Mockito.when((Object)pulsar.getLocalZkCacheService()).thenReturn((Object)localZkCache);
        Mockito.when((Object)localZkCache.policiesCache()).thenReturn((Object)poilciesCache);
        ((ZooKeeperDataCache)Mockito.doNothing().when((Object)poilciesCache)).registerListener((ZooKeeperCacheListener)Mockito.any());
        MetadataStoreExtended store = (MetadataStoreExtended)Mockito.mock(MetadataStoreExtended.class);
        Mockito.when((Object)pulsar.getLocalMetadataStore()).thenReturn((Object)store);
        Mockito.when((Object)pulsar.getConfigurationMetadataStore()).thenReturn((Object)store);
        return NamespaceBundleFactory.createFactory((PulsarService)pulsar, (HashFunction)Hashing.crc32());
    }

    @Test
    public void testFindBundle() throws Exception {
        TreeSet partitions = Sets.newTreeSet();
        partitions.add(0L);
        partitions.add(0x40000000L);
        partitions.add(0xA0000000L);
        partitions.add(0xB0000000L);
        partitions.add(0xC0000000L);
        partitions.add(0xFFFFFFFFL);
        NamespaceBundles bundles = new NamespaceBundles(NamespaceName.get((String)"pulsar/global/ns1"), this.factory, Optional.empty(), (Collection)partitions);
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundle bundle = bundles.findBundle(topicName);
        Assert.assertTrue((boolean)bundle.includes(topicName));
        topicName = TopicName.get((String)"persistent://pulsar/use/ns2/topic-2");
        try {
            bundles.findBundle(topicName);
            Assert.fail((String)"Should have failed due to mismatched namespace name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Long hashKey = this.factory.getLongHashCode(topicName.toString());
        SortedSet<Long> tailSet = partitions.tailSet(hashKey);
        tailSet.add(hashKey);
        Iterator iter = tailSet.iterator();
        iter.next();
        SortedSet<Long> newPar = tailSet.tailSet((Long)iter.next());
        try {
            bundles = new NamespaceBundles(topicName.getNamespaceObject(), this.factory, Optional.empty(), newPar);
            bundles.findBundle(topicName);
            Assert.fail((String)"Should have failed due to out-of-range");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSplitBundles() throws Exception {
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = this.factory.getBundles(nsname);
        NamespaceBundle bundle = bundles.findBundle(topicName);
        int numberSplitBundles = 4;
        Pair splitBundles = (Pair)this.factory.splitBundles(bundle, 4, null).join();
        int totalExpectedSplitBundles = bundles.getBundles().size() + 4 - 1;
        this.validateSplitBundlesRange(bundles.getFullBundle(), (List)splitBundles.getRight());
        Assert.assertEquals((int)totalExpectedSplitBundles, (int)((NamespaceBundles)splitBundles.getLeft()).getBundles().size());
        NamespaceBundleFactory utilityFactory = this.getNamespaceBundleFactory();
        NamespaceBundles bundles2 = (NamespaceBundles)splitBundles.getLeft();
        NamespaceBundle testChildBundle = (NamespaceBundle)bundles2.getBundles().get(0);
        Pair<NamespaceBundles, List<NamespaceBundle>> splitChildBundles = this.splitBundlesUtilFactory(utilityFactory, nsname, bundles2, testChildBundle, 4);
        totalExpectedSplitBundles = bundles2.getBundles().size() + 4 - 1;
        this.validateSplitBundlesRange(testChildBundle, (List)splitChildBundles.getRight());
        Assert.assertEquals((int)totalExpectedSplitBundles, (int)((NamespaceBundles)splitChildBundles.getLeft()).getBundles().size());
        NamespaceBundle testChildBundl2 = (NamespaceBundle)bundles2.getBundles().get(1);
        Pair<NamespaceBundles, List<NamespaceBundle>> splitChildBundles2 = this.splitBundlesUtilFactory(utilityFactory, nsname, bundles2, testChildBundl2, 3);
        totalExpectedSplitBundles = bundles2.getBundles().size() + 3 - 1;
        this.validateSplitBundlesRange(testChildBundl2, (List)splitChildBundles2.getRight());
        Assert.assertEquals((int)totalExpectedSplitBundles, (int)((NamespaceBundles)splitChildBundles2.getLeft()).getBundles().size());
    }

    @Test
    public void testSplitBundleInTwo() throws Exception {
        int NO_BUNDLES = 2;
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = this.factory.getBundles(nsname);
        NamespaceBundle bundle = bundles.findBundle(topicName);
        Pair splitBundles = (Pair)this.factory.splitBundles(bundle, 2, null).join();
        Assert.assertNotNull((Object)splitBundles);
        this.assertBundleDivideInTwo(bundle, (List)splitBundles.getRight());
        NamespaceBundleFactory utilityFactory = this.getNamespaceBundleFactory();
        this.assertBundles(utilityFactory, nsname, bundle, (Pair<NamespaceBundles, List<NamespaceBundle>>)splitBundles, 2);
        Pair<NamespaceBundles, List<NamespaceBundle>> splitChildBundles = this.splitBundlesUtilFactory(utilityFactory, nsname, (NamespaceBundles)splitBundles.getLeft(), (NamespaceBundle)((List)splitBundles.getRight()).get(0), 2);
        this.assertBundles(utilityFactory, nsname, (NamespaceBundle)((List)splitBundles.getRight()).get(0), splitChildBundles, 2);
        splitChildBundles = this.splitBundlesUtilFactory(utilityFactory, nsname, (NamespaceBundles)splitBundles.getLeft(), (NamespaceBundle)((List)splitBundles.getRight()).get(1), 2);
        this.assertBundles(utilityFactory, nsname, (NamespaceBundle)((List)splitBundles.getRight()).get(1), splitChildBundles, 2);
    }

    @Test
    public void testSplitBundleByFixBoundary() throws Exception {
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        NamespaceBundles bundles = this.factory.getBundles(nsname);
        NamespaceBundle bundleToSplit = (NamespaceBundle)bundles.getBundles().get(0);
        try {
            this.factory.splitBundles(bundleToSplit, 0, bundleToSplit.getLowerEndpoint());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.factory.splitBundles(bundleToSplit, 0, bundleToSplit.getUpperEndpoint());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Long fixBoundary = bundleToSplit.getLowerEndpoint() + 10L;
        Pair splitBundles = (Pair)this.factory.splitBundles(bundleToSplit, 0, fixBoundary).join();
        Assert.assertEquals((Object)((NamespaceBundle)((List)splitBundles.getRight()).get(0)).getLowerEndpoint(), (Object)bundleToSplit.getLowerEndpoint());
        Assert.assertEquals((long)((NamespaceBundle)((List)splitBundles.getRight()).get(1)).getLowerEndpoint(), (long)(bundleToSplit.getLowerEndpoint() + fixBoundary));
    }

    private void validateSplitBundlesRange(NamespaceBundle fullBundle, List<NamespaceBundle> splitBundles) {
        Assert.assertNotNull((Object)fullBundle);
        Assert.assertNotNull(splitBundles);
        Range fullRange = fullBundle.getKeyRange();
        Range span = splitBundles.get(0).getKeyRange();
        for (NamespaceBundle bundle : splitBundles) {
            span = span.span(bundle.getKeyRange());
        }
        Assert.assertEquals((Object)span, (Object)fullRange);
    }

    private Pair<NamespaceBundles, List<NamespaceBundle>> splitBundlesUtilFactory(NamespaceBundleFactory utilityFactory, NamespaceName nsname, NamespaceBundles bundles, NamespaceBundle targetBundle, int numBundles) throws Exception {
        Field bCacheField = NamespaceBundleFactory.class.getDeclaredField("bundlesCache");
        bCacheField.setAccessible(true);
        ((AsyncLoadingCache)bCacheField.get(utilityFactory)).put((Object)nsname, CompletableFuture.completedFuture(bundles));
        return (Pair)utilityFactory.splitBundles(targetBundle, numBundles, null).join();
    }

    private void assertBundles(NamespaceBundleFactory utilityFactory, NamespaceName nsname, NamespaceBundle bundle, Pair<NamespaceBundles, List<NamespaceBundle>> splitBundles, int numBundles) throws Exception {
        NamespaceBundle bundle1 = (NamespaceBundle)((List)splitBundles.getRight()).get(0);
        NamespaceBundle bundle2 = (NamespaceBundle)((List)splitBundles.getRight()).get(1);
        NamespaceBundles nspaceBundles = (NamespaceBundles)splitBundles.getLeft();
        Pair<NamespaceBundles, List<NamespaceBundle>> bundle1Split = this.splitBundlesUtilFactory(utilityFactory, nsname, nspaceBundles, bundle1, numBundles);
        this.assertBundleDivideInTwo(bundle1, (List)bundle1Split.getRight());
        Pair<NamespaceBundles, List<NamespaceBundle>> bundle2Split = this.splitBundlesUtilFactory(utilityFactory, nsname, nspaceBundles, bundle2, numBundles);
        this.assertBundleDivideInTwo(bundle2, (List)bundle2Split.getRight());
    }

    private void assertBundleDivideInTwo(NamespaceBundle bundle, List<NamespaceBundle> bundles) {
        Assert.assertEquals((int)bundles.size(), (int)2);
        String[] range = bundle.getBundleRange().split("_");
        long lower = Long.decode(range[0]);
        long upper = Long.decode(range[1]);
        long middle = (upper - lower) / 2L + lower;
        String lRange = String.format("0x%08x_0x%08x", lower, middle);
        String uRange = String.format("0x%08x_0x%08x", middle, upper);
        Assert.assertEquals((String)lRange, (String)bundles.get(0).getBundleRange());
        Assert.assertEquals((String)uRange, (String)bundles.get(1).getBundleRange());
        log.info("[{},{}] => [{},{}]", new Object[]{range[0], range[1], lRange, uRange});
    }
}

