/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.TopicCountEquallyDivideBundleSplitAlgorithm;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TopicCountEquallyDivideBundleSplitAlgorithmTest {
    @Test
    public void testWrongArg() {
        TopicCountEquallyDivideBundleSplitAlgorithm algorithm = new TopicCountEquallyDivideBundleSplitAlgorithm();
        Assert.assertThrows(NullPointerException.class, () -> algorithm.getSplitBoundary(null, null));
    }

    @Test
    public void testTopicsSizeLessThan1() {
        TopicCountEquallyDivideBundleSplitAlgorithm algorithm = new TopicCountEquallyDivideBundleSplitAlgorithm();
        NamespaceService mockNamespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        NamespaceBundle mockNamespaceBundle = (NamespaceBundle)Mockito.mock(NamespaceBundle.class);
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(Lists.newArrayList((Object[])new String[]{"a"}))).when((Object)mockNamespaceService)).getOwnedTopicListForNamespaceBundle(mockNamespaceBundle);
        Assert.assertNull(algorithm.getSplitBoundary(mockNamespaceService, mockNamespaceBundle).join());
    }

    @Test
    public void testAlgorithmReturnCorrectResult() {
        TopicCountEquallyDivideBundleSplitAlgorithm algorithm = new TopicCountEquallyDivideBundleSplitAlgorithm();
        ArrayList mockTopics = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        NamespaceService namespaceServiceForMockResult = (NamespaceService)Mockito.mock(NamespaceService.class);
        NamespaceBundle namespaceBundleForMockResult = (NamespaceBundle)Mockito.mock(NamespaceBundle.class);
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(mockTopics)).when((Object)namespaceServiceForMockResult)).getOwnedTopicListForNamespaceBundle(namespaceBundleForMockResult);
        ArrayList hashList = new ArrayList();
        NamespaceBundleFactory namespaceBundleFactoryForMockResult = (NamespaceBundleFactory)Mockito.mock(NamespaceBundleFactory.class);
        mockTopics.forEach(topic -> {
            long hashValue = Hashing.crc32().hashString((CharSequence)topic, Charsets.UTF_8).padToLong();
            ((NamespaceBundle)Mockito.doReturn((Object)namespaceBundleFactoryForMockResult).when((Object)namespaceBundleForMockResult)).getNamespaceBundleFactory();
            ((NamespaceBundleFactory)Mockito.doReturn((Object)hashValue).when((Object)namespaceBundleFactoryForMockResult)).getLongHashCode(topic);
            hashList.add(hashValue);
        });
        Collections.sort(hashList);
        long splitStart = (Long)hashList.get(Math.max(hashList.size() / 2 - 1, 0));
        long splitEnd = (Long)hashList.get(hashList.size() / 2);
        long splitMiddleForMockResult = splitStart + (splitEnd - splitStart) / 2L;
        NamespaceService mockNamespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        NamespaceBundle mockNamespaceBundle = (NamespaceBundle)Mockito.mock(NamespaceBundle.class);
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(mockTopics)).when((Object)mockNamespaceService)).getOwnedTopicListForNamespaceBundle(mockNamespaceBundle);
        NamespaceBundleFactory mockNamespaceBundleFactory = (NamespaceBundleFactory)Mockito.mock(NamespaceBundleFactory.class);
        mockTopics.forEach(topic -> {
            ((NamespaceBundle)Mockito.doReturn((Object)mockNamespaceBundleFactory).when((Object)mockNamespaceBundle)).getNamespaceBundleFactory();
            long hashValue = Hashing.crc32().hashString((CharSequence)topic, Charsets.UTF_8).padToLong();
            ((NamespaceBundleFactory)Mockito.doReturn((Object)hashValue).when((Object)mockNamespaceBundleFactory)).getLongHashCode(topic);
        });
        Assert.assertEquals((long)((Long)algorithm.getSplitBoundary(mockNamespaceService, mockNamespaceBundle).join()), (long)splitMiddleForMockResult);
    }
}

