/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Files;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class FileServer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FileServer.class);
    private static final String HEALTH_PATH = "/health";
    private final HttpServer httpServer = HttpServer.create(new InetSocketAddress(0), 0);

    public FileServer() throws IOException {
        this.httpServer.setExecutor(null);
        this.httpServer.createContext(HEALTH_PATH, he -> he.sendResponseHeaders(204, 0L));
    }

    public void serveFile(String path, File file) {
        Assert.assertTrue((boolean)file.exists(), (String)(file.getAbsolutePath() + " doesn't exist."));
        this.httpServer.createContext(path, he -> {
            try {
                Headers headers = he.getResponseHeaders();
                headers.add("Content-Type", "application/octet-stream");
                he.sendResponseHeaders(200, file.length());
                try (OutputStream outputStream = he.getResponseBody();){
                    Files.copy(file.toPath(), outputStream);
                }
            }
            catch (Exception e) {
                log.error("Error serving file {} for path {}", new Object[]{file, path, e});
            }
        });
    }

    public void start() {
        this.httpServer.start();
        this.waitUntilServerIsAvailable();
    }

    private void waitUntilServerIsAvailable() {
        Awaitility.await().ignoreExceptions().untilAsserted(() -> {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(this.getUrl(HEALTH_PATH)).openConnection();
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            try {
                urlConnection.connect();
                Assert.assertEquals((int)urlConnection.getResponseCode(), (int)204);
            }
            finally {
                urlConnection.disconnect();
            }
        });
    }

    public void stop() {
        this.httpServer.stop(0);
    }

    public String getUrl(String path) {
        return "http://127.0.0.1:" + this.httpServer.getAddress().getPort() + path;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }
}

