/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class PulsarFunctionTestUtils {
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionTestUtils.class);

    public static String getPrometheusMetrics(int metricsPort) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        URL url = new URL(String.format("http://%s:%s/metrics", "localhost", metricsPort));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            result.append(line + System.lineSeparator());
        }
        rd.close();
        return result.toString();
    }

    @Test
    void testParseMetrics() throws IOException {
        String sampleMetrics = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("prometheus_metrics_sample.txt"), (Charset)StandardCharsets.UTF_8);
        PulsarFunctionTestUtils.parseMetrics(sampleMetrics);
    }

    public static Map<String, Metric> parseMetrics(String metrics) {
        HashMap<String, Metric> parsed = new HashMap<String, Metric>();
        Pattern pattern = Pattern.compile("^(\\w+)(\\{[^\\}]+\\})?\\s([+-]?[\\d\\w\\.-]+)(\\s(\\d+))?$");
        Pattern tagsPattern = Pattern.compile("(\\w+)=\"([^\"]+)\"(,\\s?)?");
        Arrays.asList(metrics.split("\n")).forEach(line -> {
            if (line.isEmpty() || line.startsWith("#")) {
                return;
            }
            Matcher matcher = pattern.matcher((CharSequence)line);
            Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Cannot parse metrics from line: '" + line + "'"));
            String name = matcher.group(1);
            Metric m = new Metric();
            String numericValue = matcher.group(3);
            m.value = numericValue.equalsIgnoreCase("-Inf") ? Double.NEGATIVE_INFINITY : (numericValue.equalsIgnoreCase("+Inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(numericValue));
            String tags = matcher.group(2);
            if (tags != null) {
                tags = tags.replace("{", "").replace("}", "");
                Matcher tagsMatcher = tagsPattern.matcher(tags);
                while (tagsMatcher.find()) {
                    String tag = tagsMatcher.group(1);
                    String value = tagsMatcher.group(2);
                    m.tags.put(tag, value);
                }
            }
            parsed.put(name, m);
        });
        return parsed;
    }

    public static class Metric {
        public final Map<String, String> tags = new TreeMap<String, String>();
        public double value;

        public String toString() {
            return "PulsarFunctionTestUtils.Metric(tags=" + this.tags + ", value=" + this.value + ")";
        }
    }
}

