/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.socks5.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import org.apache.pulsar.socks5.config.Socks5Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5InitialRequest> {
    private static final Logger log = LoggerFactory.getLogger(InitialRequestHandler.class);
    private final Socks5Config socks5Config;

    public InitialRequestHandler(Socks5Config socks5Config) {
        this.socks5Config = socks5Config;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DefaultSocks5InitialRequest msg) throws Exception {
        if (SocksVersion.SOCKS5.equals((Object)msg.version())) {
            if (msg.decoderResult().isFailure()) {
                log.warn("decode failure : {}", (Object)msg.decoderResult());
                ctx.fireChannelRead((Object)msg);
            } else if (this.socks5Config.isEnableAuth()) {
                ctx.writeAndFlush((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.PASSWORD));
            } else {
                ctx.writeAndFlush((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.NO_AUTH));
            }
        }
    }
}

