/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.socks5.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.pulsar.socks5.auth.DefaultPasswordAuthImpl;
import org.apache.pulsar.socks5.auth.PasswordAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5PasswordAuthRequest> {
    private static final Logger log = LoggerFactory.getLogger(PasswordAuthRequestHandler.class);
    private final PasswordAuth passwordAuth = new DefaultPasswordAuthImpl();

    protected void channelRead0(ChannelHandlerContext ctx, DefaultSocks5PasswordAuthRequest msg) throws Exception {
        if (this.passwordAuth.auth(msg.username(), msg.password())) {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
        } else {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

