/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.SubscribeRate;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlogQuotaMap(ServiceConfiguration configuration) {
        return Collections.singletonMap(BacklogQuota.BacklogQuotaType.destination_storage, ConfigHelper.backlogQuota(configuration));
    }

    public static BacklogQuota backlogQuota(ServiceConfiguration configuration) {
        return BacklogQuota.builder().limitSize(configuration.getBacklogQuotaDefaultLimitGB() * 1024L * 1024L * 1024L).retentionPolicy(configuration.getBacklogQuotaDefaultRetentionPolicy()).build();
    }

    public static DispatchRate topicDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerTopicInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerTopicInByte()).ratePeriodInSecond(1).build();
    }

    public static DispatchRate subscriptionDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    public static DispatchRate replicatorDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerReplicatorInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerReplicatorInByte()).ratePeriodInSecond(1).build();
    }

    public static SubscribeRate subscribeRate(ServiceConfiguration configuration) {
        return new SubscribeRate(configuration.getSubscribeThrottlingRatePerConsumer(), configuration.getSubscribeRatePeriodPerConsumerInSecond());
    }
}

