/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.TimeAverageBrokerData;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimeAverageBrokerDataTest {
    @Test
    public void testIllegalArg() {
        TimeAverageBrokerData timeAverageBrokerData = new TimeAverageBrokerData();
        Assert.assertThrows(NullPointerException.class, () -> timeAverageBrokerData.reset(null, null, null));
    }

    @Test
    public void testResetMethodOfOneBundlesEmptyBundleMap() {
        TimeAverageBrokerData timeAverageBrokerData = new TimeAverageBrokerData();
        HashSet<String> bundles = new HashSet<String>();
        bundles.add("a");
        HashMap emptyMap = new HashMap();
        NamespaceBundleStats namespaceBundleStats = new NamespaceBundleStats();
        namespaceBundleStats.msgThroughputIn = 1.0;
        namespaceBundleStats.msgThroughputOut = 2.0;
        namespaceBundleStats.msgRateIn = 3.0;
        namespaceBundleStats.msgRateOut = 4.0;
        timeAverageBrokerData.reset(bundles, emptyMap, namespaceBundleStats);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputIn(), (double)1.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputOut(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateIn(), (double)3.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputIn(), (double)1.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputOut(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateIn(), (double)3.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateOut(), (double)4.0);
    }

    @Test
    public void testResetMethodOfMultipleBundlesEmptyBundleMap() {
        TimeAverageBrokerData timeAverageBrokerData = new TimeAverageBrokerData();
        HashSet<String> bundles = new HashSet<String>();
        bundles.add("a");
        bundles.add("b");
        HashMap emptyMap = new HashMap();
        NamespaceBundleStats namespaceBundleStats = new NamespaceBundleStats();
        namespaceBundleStats.msgThroughputIn = 1.0;
        namespaceBundleStats.msgThroughputOut = 2.0;
        namespaceBundleStats.msgRateIn = 3.0;
        namespaceBundleStats.msgRateOut = 4.0;
        timeAverageBrokerData.reset(bundles, emptyMap, namespaceBundleStats);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputIn(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateIn(), (double)6.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateOut(), (double)8.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputIn(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateIn(), (double)6.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateOut(), (double)8.0);
    }

    @Test
    public void testResetMethodOfOneBundles() {
        TimeAverageBrokerData timeAverageBrokerData = new TimeAverageBrokerData();
        HashSet<String> bundles = new HashSet<String>();
        bundles.add("a");
        HashMap<String, BundleData> data = new HashMap<String, BundleData>();
        TimeAverageMessageData timeAverageMessageData = new TimeAverageMessageData();
        timeAverageMessageData.setMsgThroughputIn(1.0);
        timeAverageMessageData.setMsgThroughputOut(2.0);
        timeAverageMessageData.setMsgRateIn(3.0);
        timeAverageMessageData.setMsgRateOut(4.0);
        BundleData bundleData = new BundleData();
        bundleData.setLongTermData(timeAverageMessageData);
        bundleData.setShortTermData(timeAverageMessageData);
        data.put("a", bundleData);
        timeAverageBrokerData.reset(bundles, data, null);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputIn(), (double)1.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputOut(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateIn(), (double)3.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputIn(), (double)1.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputOut(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateIn(), (double)3.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateOut(), (double)4.0);
    }

    @Test
    public void testResetMethodOfMultipleBundles() {
        TimeAverageBrokerData timeAverageBrokerData = new TimeAverageBrokerData();
        HashSet<String> bundles = new HashSet<String>();
        bundles.add("a");
        bundles.add("c");
        HashMap<String, BundleData> data = new HashMap<String, BundleData>();
        TimeAverageMessageData timeAverageMessageData = new TimeAverageMessageData();
        timeAverageMessageData.setMsgThroughputIn(1.0);
        timeAverageMessageData.setMsgThroughputOut(2.0);
        timeAverageMessageData.setMsgRateIn(3.0);
        timeAverageMessageData.setMsgRateOut(4.0);
        BundleData bundleData = new BundleData();
        bundleData.setLongTermData(timeAverageMessageData);
        bundleData.setShortTermData(timeAverageMessageData);
        data.put("a", bundleData);
        data.put("c", bundleData);
        timeAverageBrokerData.reset(bundles, data, null);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputIn(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgThroughputOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateIn(), (double)6.0);
        Assert.assertEquals((double)timeAverageBrokerData.getShortTermMsgRateOut(), (double)8.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputIn(), (double)2.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgThroughputOut(), (double)4.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateIn(), (double)6.0);
        Assert.assertEquals((double)timeAverageBrokerData.getLongTermMsgRateOut(), (double)8.0);
    }
}

