/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockAuthentication;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class AuthLogsTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AuthLogsTest.class);

    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setClusterName("test");
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{"org.apache.pulsar.broker.auth.MockAuthenticationProvider"}));
        this.conf.setAuthorizationProvider("org.apache.pulsar.broker.auth.MockAuthorizationProvider");
        this.conf.setAuthorizationEnabled(true);
        this.conf.setAuthorizationAllowWildcardsMatching(true);
        this.conf.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"super"}));
        this.internalSetup();
        try (PulsarAdmin admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.pass")).serviceHttpUrl(this.brokerUrl.toString()).build();){
            admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
            admin.tenants().createTenant("public", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
            admin.namespaces().createNamespace("public/default");
            admin.namespaces().setNamespaceReplicationClusters("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        }
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Test
    public void binaryEndpoint() throws Exception {
        Consumer consumer3;
        Throwable throwable;
        Producer producer;
        log.info("LOG_TEST_SUCCESS_CLIENT should succeeed both client");
        try (PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.pass")).build();){
            producer = client.newProducer().topic("foobar").create();
            throwable = null;
            try {
                Consumer consumer2 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                Throwable throwable2 = null;
                if (consumer2 != null) {
                    if (throwable2 != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (producer != null) {
                    if (throwable != null) {
                        try {
                            producer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        producer.close();
                    }
                }
            }
        }
        log.info("LOG_TEST_PRODUCER_AUTHN_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("fail.ignored")).build();
            var2_10 = null;
            try {
                producer = client.newProducer().topic("foobar").create();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (producer != null) {
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            producer.close();
                        }
                    }
                }
            }
            catch (Throwable producer2) {
                var2_10 = producer2;
                throw producer2;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable producer2) {
                            var2_10.addSuppressed(producer2);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client2) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHN_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("error.ignored")).build();
            var2_10 = null;
            try {
                producer = client.newProducer().topic("foobar").create();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (producer != null) {
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                        } else {
                            producer.close();
                        }
                    }
                }
            }
            catch (Throwable producer3) {
                var2_10 = producer3;
                throw producer3;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable producer3) {
                            var2_10.addSuppressed(producer3);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client3) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHN_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("fail.ignored")).build();
            var2_10 = null;
            try {
                consumer3 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (consumer3 != null) {
                        if (throwable != null) {
                            try {
                                consumer3.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            consumer3.close();
                        }
                    }
                }
            }
            catch (Throwable consumer3) {
                var2_10 = consumer3;
                throw consumer3;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable consumer3) {
                            var2_10.addSuppressed(consumer3);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client4) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHN_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("error.ignored")).build();
            var2_10 = null;
            try {
                consumer3 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable12) {
                    throwable = throwable12;
                    throw throwable12;
                }
                finally {
                    if (consumer3 != null) {
                        if (throwable != null) {
                            try {
                                consumer3.close();
                            }
                            catch (Throwable throwable13) {
                                throwable.addSuppressed(throwable13);
                            }
                        } else {
                            consumer3.close();
                        }
                    }
                }
            }
            catch (Throwable consumer4) {
                var2_10 = consumer4;
                throw consumer4;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable consumer4) {
                            var2_10.addSuppressed(consumer4);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthenticationException client5) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHZ_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.fail")).build();
            var2_10 = null;
            try {
                producer = client.newProducer().topic("foobar").create();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable14) {
                    throwable = throwable14;
                    throw throwable14;
                }
                finally {
                    if (producer != null) {
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable15) {
                                throwable.addSuppressed(throwable15);
                            }
                        } else {
                            producer.close();
                        }
                    }
                }
            }
            catch (Throwable producer4) {
                var2_10 = producer4;
                throw producer4;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable producer4) {
                            var2_10.addSuppressed(producer4);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client6) {
            // empty catch block
        }
        log.info("LOG_TEST_PRODUCER_AUTHZ_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.error")).build();
            var2_10 = null;
            try {
                producer = client.newProducer().topic("foobar").create();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable16) {
                    throwable = throwable16;
                    throw throwable16;
                }
                finally {
                    if (producer != null) {
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable17) {
                                throwable.addSuppressed(throwable17);
                            }
                        } else {
                            producer.close();
                        }
                    }
                }
            }
            catch (Throwable producer5) {
                var2_10 = producer5;
                throw producer5;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable producer5) {
                            var2_10.addSuppressed(producer5);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client7) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHZ_FAIL");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.fail")).build();
            var2_10 = null;
            try {
                consumer3 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable18) {
                    throwable = throwable18;
                    throw throwable18;
                }
                finally {
                    if (consumer3 != null) {
                        if (throwable != null) {
                            try {
                                consumer3.close();
                            }
                            catch (Throwable throwable19) {
                                throwable.addSuppressed(throwable19);
                            }
                        } else {
                            consumer3.close();
                        }
                    }
                }
            }
            catch (Throwable consumer5) {
                var2_10 = consumer5;
                throw consumer5;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable consumer5) {
                            var2_10.addSuppressed(consumer5);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthorizationException client8) {
            // empty catch block
        }
        log.info("LOG_TEST_CONSUMER_AUTHZ_ERROR");
        try {
            client = PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrl()).authentication((Authentication)new MockAuthentication("pass.error")).build();
            var2_10 = null;
            try {
                consumer3 = client.newConsumer().topic(new String[]{"foobar"}).subscriptionName("foobar").subscribe();
                throwable = null;
                try {
                    Assert.fail((String)"Should fail auth");
                }
                catch (Throwable throwable20) {
                    throwable = throwable20;
                    throw throwable20;
                }
                finally {
                    if (consumer3 != null) {
                        if (throwable != null) {
                            try {
                                consumer3.close();
                            }
                            catch (Throwable throwable21) {
                                throwable.addSuppressed(throwable21);
                            }
                        } else {
                            consumer3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable22) {
                var2_10 = throwable22;
                throw throwable22;
            }
            finally {
                if (client != null) {
                    if (var2_10 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable23) {
                            var2_10.addSuppressed(throwable23);
                        }
                    } else {
                        client.close();
                    }
                }
            }
        }
        catch (PulsarClientException.AuthorizationException authorizationException) {
            // empty catch block
        }
        log.info("LOG_TEST_CLIENT_DONE");
    }

    @Test
    public void httpEndpoint() throws Exception {
        log.info("LOG_TEST_SUCCESS_CLIENT should succeeed both client");
        try (PulsarAdmin admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.pass")).serviceHttpUrl(this.brokerUrl.toString()).build();){
            admin.namespaces().getNamespaces("public");
        }
        log.info("LOG_TEST_HTTP_AUTHN_FAIL");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("fail.ignore")).serviceHttpUrl(this.brokerUrl.toString()).build();
            var2_6 = null;
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            catch (Throwable throwable) {
                var2_6 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_6 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_6.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin2) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHN_ERROR");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("error.ignore")).serviceHttpUrl(this.brokerUrl.toString()).build();
            var2_6 = null;
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            catch (Throwable throwable) {
                var2_6 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_6 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_6.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin3) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHZ_FAIL");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.fail")).serviceHttpUrl(this.brokerUrl.toString()).build();
            var2_6 = null;
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            catch (Throwable throwable) {
                var2_6 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_6 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_6.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException admin4) {
            // empty catch block
        }
        log.info("LOG_TEST_HTTP_AUTHZ_ERROR");
        try {
            admin = PulsarAdmin.builder().authentication((Authentication)new MockAuthentication("pass.error")).serviceHttpUrl(this.brokerUrl.toString()).build();
            var2_6 = null;
            try {
                admin.namespaces().getNamespaces("public");
                Assert.fail((String)"Should fail auth");
            }
            catch (Throwable throwable) {
                var2_6 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_6 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_6.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.ServerSideErrorException serverSideErrorException) {
            // empty catch block
        }
        log.info("LOG_TEST_CLIENT_DONE");
    }
}

