/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.broker.protocol.ProtocolHandlers;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ProtocolHandlersTest {
    private static final String protocol1 = "protocol1";
    private ProtocolHandler handler1;
    private NarClassLoader ncl1;
    private static final String protocol2 = "protocol2";
    private ProtocolHandler handler2;
    private NarClassLoader ncl2;
    private static final String protocol3 = "protocol3";
    private Map<String, ProtocolHandlerWithClassLoader> handlerMap;
    private ProtocolHandlers handlers;

    @BeforeMethod
    public void setup() {
        this.handler1 = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        this.ncl1 = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        this.handler2 = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        this.ncl2 = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        this.handlerMap = new HashMap<String, ProtocolHandlerWithClassLoader>();
        this.handlerMap.put(protocol1, new ProtocolHandlerWithClassLoader(this.handler1, this.ncl1));
        this.handlerMap.put(protocol2, new ProtocolHandlerWithClassLoader(this.handler2, this.ncl2));
        this.handlers = new ProtocolHandlers(this.handlerMap);
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.handlers.close();
        ((ProtocolHandler)Mockito.verify((Object)this.handler1, (VerificationMode)Mockito.times((int)1))).close();
        ((ProtocolHandler)Mockito.verify((Object)this.handler2, (VerificationMode)Mockito.times((int)1))).close();
        ((NarClassLoader)Mockito.verify((Object)this.ncl1, (VerificationMode)Mockito.times((int)1))).close();
        ((NarClassLoader)Mockito.verify((Object)this.ncl2, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testGetProtocol() {
        Assert.assertSame((Object)this.handler1, (Object)this.handlers.protocol(protocol1));
        Assert.assertSame((Object)this.handler2, (Object)this.handlers.protocol(protocol2));
        Assert.assertNull((Object)this.handlers.protocol(protocol3));
    }

    @Test
    public void testInitialize() throws Exception {
        ServiceConfiguration conf = new ServiceConfiguration();
        this.handlers.initialize(conf);
        ((ProtocolHandler)Mockito.verify((Object)this.handler1, (VerificationMode)Mockito.times((int)1))).initialize((ServiceConfiguration)ArgumentMatchers.same((Object)conf));
        ((ProtocolHandler)Mockito.verify((Object)this.handler2, (VerificationMode)Mockito.times((int)1))).initialize((ServiceConfiguration)ArgumentMatchers.same((Object)conf));
    }

    @Test
    public void testGetProtocolDataToAdvertise() {
        String protocolData1 = "protocolData1";
        String protocolData2 = "protocolData2";
        Mockito.when((Object)this.handler1.getProtocolDataToAdvertise()).thenReturn((Object)protocolData1);
        Mockito.when((Object)this.handler2.getProtocolDataToAdvertise()).thenReturn((Object)protocolData2);
        Map protocols = this.handlers.getProtocolDataToAdvertise();
        Assert.assertEquals((int)2, (int)protocols.size());
        Assert.assertEquals((String)protocolData1, (String)((String)protocols.get(protocol1)));
        Assert.assertEquals((String)protocolData2, (String)((String)protocols.get(protocol2)));
    }

    @Test
    public void testStart() {
        BrokerService service = (BrokerService)Mockito.mock(BrokerService.class);
        this.handlers.start(service);
        ((ProtocolHandler)Mockito.verify((Object)this.handler1, (VerificationMode)Mockito.times((int)1))).start((BrokerService)ArgumentMatchers.same((Object)service));
        ((ProtocolHandler)Mockito.verify((Object)this.handler2, (VerificationMode)Mockito.times((int)1))).start((BrokerService)ArgumentMatchers.same((Object)service));
    }

    @Test
    public void testNewChannelInitializersSuccess() {
        ChannelInitializer i1 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        ChannelInitializer i2 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        HashMap<InetSocketAddress, ChannelInitializer> p1Initializers = new HashMap<InetSocketAddress, ChannelInitializer>();
        p1Initializers.put(new InetSocketAddress("127.0.0.1", 6650), i1);
        p1Initializers.put(new InetSocketAddress("127.0.0.2", 6651), i2);
        ChannelInitializer i3 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        ChannelInitializer i4 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        HashMap<InetSocketAddress, ChannelInitializer> p2Initializers = new HashMap<InetSocketAddress, ChannelInitializer>();
        p2Initializers.put(new InetSocketAddress("127.0.0.3", 6650), i3);
        p2Initializers.put(new InetSocketAddress("127.0.0.4", 6651), i4);
        Mockito.when((Object)this.handler1.newChannelInitializers()).thenReturn(p1Initializers);
        Mockito.when((Object)this.handler2.newChannelInitializers()).thenReturn(p2Initializers);
        Map initializers = this.handlers.newChannelInitializers();
        Assert.assertEquals((int)2, (int)initializers.size());
        Assert.assertSame(p1Initializers, initializers.get(protocol1));
        Assert.assertSame(p2Initializers, initializers.get(protocol2));
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testNewChannelInitializersOverlapped() {
        ChannelInitializer i1 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        ChannelInitializer i2 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        HashMap<InetSocketAddress, ChannelInitializer> p1Initializers = new HashMap<InetSocketAddress, ChannelInitializer>();
        p1Initializers.put(new InetSocketAddress("127.0.0.1", 6650), i1);
        p1Initializers.put(new InetSocketAddress("127.0.0.2", 6651), i2);
        ChannelInitializer i3 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        ChannelInitializer i4 = (ChannelInitializer)Mockito.mock(ChannelInitializer.class);
        HashMap<InetSocketAddress, ChannelInitializer> p2Initializers = new HashMap<InetSocketAddress, ChannelInitializer>();
        p2Initializers.put(new InetSocketAddress("127.0.0.1", 6650), i3);
        p2Initializers.put(new InetSocketAddress("127.0.0.4", 6651), i4);
        Mockito.when((Object)this.handler1.newChannelInitializers()).thenReturn(p1Initializers);
        Mockito.when((Object)this.handler2.newChannelInitializers()).thenReturn(p2Initializers);
        this.handlers.newChannelInitializers();
    }
}

