/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.pulsar.broker.service.DistributedIdGenerator;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class DistributedIdGeneratorTest {
    private MetadataStoreExtended store;
    private CoordinationService coordinationService;

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.store = MetadataStoreExtended.create((String)"memory://local", (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        this.coordinationService = new CoordinationServiceImpl(this.store);
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.coordinationService.close();
        this.store.close();
    }

    @Test
    public void simple() throws Exception {
        DistributedIdGenerator gen1 = new DistributedIdGenerator(this.coordinationService, "/my/test/simple", "p");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-0");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-1");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-2");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-3");
        DistributedIdGenerator gen2 = new DistributedIdGenerator(this.coordinationService, "/my/test/simple", "p");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-0");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-1");
        Assert.assertEquals((String)gen1.getNextId(), (String)"p-0-4");
        Assert.assertEquals((String)gen2.getNextId(), (String)"p-1-2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrent() throws Exception {
        int Threads = 10;
        int Iterations = 100;
        CyclicBarrier barrier = new CyclicBarrier(Threads);
        CountDownLatch counter = new CountDownLatch(Threads);
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            List results = Collections.synchronizedList(Lists.newArrayList());
            for (int i = 0; i < Threads; ++i) {
                executor.execute(() -> {
                    try {
                        DistributedIdGenerator gen = new DistributedIdGenerator(this.coordinationService, "/my/test/concurrent", "prefix");
                        barrier.await();
                        for (int j = 0; j < Iterations; ++j) {
                            results.add(gen.getNextId());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        counter.countDown();
                    }
                });
            }
            counter.await();
            Assert.assertEquals((int)results.size(), (int)(Threads * Iterations));
            HashSet set = Sets.newHashSet(results);
            Assert.assertEquals((int)set.size(), (int)results.size());
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdownNow();
            }
        }
    }

    @Test
    public void invalidZnode() throws Exception {
        this.store.put("/my/test/invalid", "invalid-number".getBytes(), Optional.of(-1L));
        DistributedIdGenerator gen = new DistributedIdGenerator(this.coordinationService, "/my/test/invalid", "p");
        Assert.assertEquals((String)gen.getNextId(), (String)"p-0-0");
    }
}

