/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.SystemTopicBasedTopicPoliciesService;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class SystemTopicBasedTopicPoliciesServiceTest
extends MockedPulsarServiceBaseTest {
    private static final String NAMESPACE1 = "system-topic/namespace-1";
    private static final String NAMESPACE2 = "system-topic/namespace-2";
    private static final String NAMESPACE3 = "system-topic/namespace-3";
    private static final TopicName TOPIC1 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-1"), (String)"topic-1");
    private static final TopicName TOPIC2 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-1"), (String)"topic-2");
    private static final TopicName TOPIC3 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-2"), (String)"topic-1");
    private static final TopicName TOPIC4 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-2"), (String)"topic-2");
    private static final TopicName TOPIC5 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-3"), (String)"topic-1");
    private static final TopicName TOPIC6 = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)"system-topic/namespace-3"), (String)"topic-2");
    private NamespaceEventsSystemTopicFactory systemTopicFactory;
    private SystemTopicBasedTopicPoliciesService systemTopicBasedTopicPoliciesService;

    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        super.internalSetup();
        this.prepareData();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testGetPolicy() throws ExecutionException, InterruptedException, BrokerServiceException.TopicPoliciesCacheNotInitException {
        TopicPolicies initPolicy = TopicPolicies.builder().maxConsumerPerTopic(Integer.valueOf(10)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC1, initPolicy).get();
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.getPoliciesCacheInit(TOPIC1.getNamespaceObject())));
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC1).getMaxConsumerPerTopic(), (int)10));
        TopicPolicies policies1 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(1)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC1, policies1).get();
        TopicPolicies policies2 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(2)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC2, policies2).get();
        TopicPolicies policies3 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(3)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC3, policies3).get();
        TopicPolicies policies4 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(4)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC4, policies4).get();
        TopicPolicies policies5 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(5)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC5, policies5).get();
        TopicPolicies policies6 = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(6)).build();
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC6, policies6).get();
        Awaitility.await().untilAsserted(() -> {
            TopicPolicies policiesGet1 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC1);
            TopicPolicies policiesGet2 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC2);
            TopicPolicies policiesGet3 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC3);
            TopicPolicies policiesGet4 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC4);
            TopicPolicies policiesGet5 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC5);
            TopicPolicies policiesGet6 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC6);
            Assert.assertEquals((Object)policiesGet1, (Object)policies1);
            Assert.assertEquals((Object)policiesGet2, (Object)policies2);
            Assert.assertEquals((Object)policiesGet3, (Object)policies3);
            Assert.assertEquals((Object)policiesGet4, (Object)policies4);
            Assert.assertEquals((Object)policiesGet5, (Object)policies5);
            Assert.assertEquals((Object)policiesGet6, (Object)policies6);
        });
        Assert.assertEquals((long)this.systemTopicBasedTopicPoliciesService.getPoliciesCacheSize(), (long)6L);
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE1)));
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE2)));
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE3)));
        policies1.setMaxProducerPerTopic(Integer.valueOf(101));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC1, policies1);
        policies2.setMaxProducerPerTopic(Integer.valueOf(102));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC2, policies2);
        policies2.setMaxProducerPerTopic(Integer.valueOf(103));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC2, policies2);
        policies1.setMaxProducerPerTopic(Integer.valueOf(104));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC1, policies1);
        policies2.setMaxProducerPerTopic(Integer.valueOf(105));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC2, policies2);
        policies1.setMaxProducerPerTopic(Integer.valueOf(106));
        this.systemTopicBasedTopicPoliciesService.updateTopicPoliciesAsync(TOPIC1, policies1);
        Awaitility.await().untilAsserted(() -> {
            TopicPolicies policiesGet1 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC1);
            TopicPolicies policiesGet2 = this.systemTopicBasedTopicPoliciesService.getTopicPolicies(TOPIC2);
            Assert.assertEquals((Object)policies1, (Object)policiesGet1);
            Assert.assertEquals((Object)policies2, (Object)policiesGet2);
        });
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE2)));
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE1)));
        Assert.assertTrue((boolean)this.systemTopicBasedTopicPoliciesService.checkReaderIsCached(NamespaceName.get((String)NAMESPACE3)));
        TopicPolicies policiesGet1 = (TopicPolicies)this.systemTopicBasedTopicPoliciesService.getTopicPoliciesBypassCacheAsync(TOPIC1).get();
        Assert.assertEquals((Object)policies1, (Object)policiesGet1);
    }

    @Test
    public void testCacheCleanup() throws Exception {
        String topic = "persistent://system-topic/namespace-1/test" + UUID.randomUUID();
        TopicName topicName = TopicName.get((String)topic);
        this.admin.topics().createPartitionedTopic(topic, 3);
        this.pulsarClient.newProducer().topic(topic).create().close();
        Awaitility.await().untilAsserted(() -> this.systemTopicBasedTopicPoliciesService.cacheIsInitialized(topicName));
        this.admin.topics().setMaxConsumers(topic, 1000);
        Awaitility.await().untilAsserted(() -> AssertJUnit.assertNotNull((Object)this.admin.topics().getMaxConsumers(topic)));
        Map map = this.systemTopicBasedTopicPoliciesService.getPoliciesCache();
        Map listMap = this.systemTopicBasedTopicPoliciesService.getListeners();
        AssertJUnit.assertNotNull(map.get(topicName));
        AssertJUnit.assertEquals((int)((TopicPolicies)map.get(topicName)).getMaxConsumerPerTopic(), (int)1000);
        AssertJUnit.assertNotNull(((List)listMap.get(topicName)).get(0));
        this.admin.topics().deletePartitionedTopic(topic, true);
        this.admin.namespaces().unload(NAMESPACE1);
        AssertJUnit.assertNull(map.get(topicName));
        AssertJUnit.assertNull(listMap.get(topicName));
    }

    private void prepareData() throws PulsarAdminException {
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("system-topic", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.namespaces().createNamespace(NAMESPACE2);
        this.admin.namespaces().createNamespace(NAMESPACE3);
        this.admin.lookups().lookupTopic(TOPIC1.toString());
        this.admin.lookups().lookupTopic(TOPIC2.toString());
        this.admin.lookups().lookupTopic(TOPIC3.toString());
        this.admin.lookups().lookupTopic(TOPIC4.toString());
        this.admin.lookups().lookupTopic(TOPIC5.toString());
        this.admin.lookups().lookupTopic(TOPIC6.toString());
        this.systemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarClient);
        this.systemTopicBasedTopicPoliciesService = (SystemTopicBasedTopicPoliciesService)this.pulsar.getTopicPoliciesService();
    }
}

