/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.stats.DimensionStats;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DimensionStatsTest {
    @Test
    void shouldCalculateQuantiles() {
        DimensionStats dimensionStats = new DimensionStats("test", 100L, false);
        for (int i = 1; i <= 10000; ++i) {
            dimensionStats.recordDimensionTimeValue((long)i, TimeUnit.MILLISECONDS);
        }
        DimensionStats.DimensionStatsSnapshot snapshot = dimensionStats.getSnapshot();
        Assert.assertEquals((double)snapshot.getMeanDimension(), (double)5000.0, (double)1.0);
        Assert.assertEquals((double)snapshot.getMedianDimension(), (double)5000.0, (double)100.0);
        Assert.assertEquals((double)snapshot.getDimension75(), (double)7500.0, (double)100.0);
        Assert.assertEquals((double)snapshot.getDimension95(), (double)9500.0, (double)100.0);
        Assert.assertEquals((double)snapshot.getDimension99(), (double)9900.0, (double)100.0);
        Assert.assertEquals((double)snapshot.getDimension999(), (double)9990.0, (double)10.0);
        Assert.assertEquals((double)snapshot.getDimension9999(), (double)9999.0, (double)1.0);
        Assert.assertEquals((double)snapshot.getDimensionCount(), (double)10000.0);
        Assert.assertEquals((double)snapshot.getDimensionSum(), (double)5.0005E7);
    }
}

