/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStore;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(TransactionTest.class);
    private static final String TENANT = "tnx";
    private static final String NAMESPACE1 = "tnx/ns1";

    @BeforeMethod
    protected void setup() throws Exception {
        this.setBrokerCount(1);
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.tenants().createTenant(NamespaceName.SYSTEM_NAMESPACE.getTenant(), (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NamespaceName.SYSTEM_NAMESPACE.toString());
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 1);
        this.pulsarClient.close();
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void brokerNotInitTxnManagedLedgerTopic() throws Exception {
        String subName = "test";
        String topicName = TopicName.get((String)"tnx/ns1/test").toString();
        Consumer<byte[]> consumer = this.getConsumer(topicName, subName);
        try {
            consumer.close();
            Awaitility.await().until(() -> {
                try {
                    this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            });
            this.admin.namespaces().unload(NamespaceName.SYSTEM_NAMESPACE.toString());
            this.admin.namespaces().unload(NAMESPACE1);
            Consumer<byte[]> consumer1 = this.getConsumer(topicName, subName);
            try {
                Awaitility.await().until(() -> {
                    try {
                        this.pulsarClient.newTransaction().withTransactionTimeout(30L, TimeUnit.SECONDS).build().get();
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                });
                ConcurrentOpenHashMap topics = this.getPulsarServiceList().get(0).getBrokerService().getTopics();
                Assert.assertNull((Object)topics.get((Object)(TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"__transaction_log_").toString() + 0)));
                Assert.assertNull((Object)topics.get((Object)TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(0).toString()));
                Assert.assertNull((Object)topics.get((Object)MLPendingAckStore.getTransactionPendingAckStoreSuffix((String)topicName, (String)subName)));
            }
            finally {
                if (Collections.singletonList(consumer1).get(0) != null) {
                    consumer1.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    public Consumer<byte[]> getConsumer(String topicName, String subName) throws PulsarClientException {
        return this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscriptionType(SubscriptionType.Shared).enableBatchIndexAcknowledgment(true).subscribe();
    }
}

