/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SizeUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ProducerQueueSizeTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="matrix")
    public Object[][] matrix() {
        return new Object[][]{{Boolean.FALSE, Boolean.FALSE}, {Boolean.FALSE, Boolean.TRUE}, {Boolean.TRUE, Boolean.FALSE}, {Boolean.TRUE, Boolean.TRUE}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="matrix")
    public void testRemoveMaxQueueLimit(boolean blockIfQueueFull, boolean partitioned) throws Exception {
        String topic = this.newTopicName();
        if (partitioned) {
            this.admin.topics().createPartitionedTopic(topic, 10);
        }
        PulsarClient client = PulsarClient.builder().serviceUrl(this.brokerUrl.toString()).memoryLimit(10L, SizeUnit.KILO_BYTES).build();
        try {
            Producer producer = client.newProducer(Schema.STRING).topic(topic).blockIfQueueFull(blockIfQueueFull).maxPendingMessages(0).maxPendingMessagesAcrossPartitions(0).create();
            try {
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                for (int i = 0; i < 100; ++i) {
                    futures.add(producer.sendAsync((Object)"hello"));
                }
                producer.flush();
                for (CompletableFuture f : futures) {
                    f.get();
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }
}

