/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.stream.IntStream;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.impl.ConnectionPool;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class ConnectionPoolTest
extends MockedPulsarServiceBaseTest {
    String serviceUrl;

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.serviceUrl = "pulsar://non-existing-dns-name:" + this.pulsar.getBrokerListenPort().get();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSingleIpAddress() throws Exception {
        ClientConfigurationData conf = new ClientConfigurationData();
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        conf.setServiceUrl(this.serviceUrl);
        PulsarClientImpl client = new PulsarClientImpl(conf, eventLoop, pool);
        ArrayList result = Lists.newArrayList();
        result.add(InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)pool.resolveName("non-existing-dns-name")).thenReturn(CompletableFuture.completedFuture(result));
        client.newProducer().topic("persistent://sample/standalone/ns/my-topic").create();
        client.close();
        eventLoop.shutdownGracefully();
    }

    @Test
    public void testDoubleIpAddress() throws Exception {
        String serviceUrl = "pulsar://non-existing-dns-name:" + this.pulsar.getBrokerListenPort().get();
        ClientConfigurationData conf = new ClientConfigurationData();
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        conf.setServiceUrl(serviceUrl);
        PulsarClientImpl client = new PulsarClientImpl(conf, eventLoop, pool);
        ArrayList result = Lists.newArrayList();
        result.add(InetAddress.getByName("127.0.0.99"));
        result.add(InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)pool.resolveName("non-existing-dns-name")).thenReturn(CompletableFuture.completedFuture(result));
        client.newProducer().topic("persistent://sample/standalone/ns/my-topic").create();
        client.close();
        eventLoop.shutdownGracefully();
    }

    @Test
    public void testNoConnectionPool() throws Exception {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setConnectionsPerBroker(0);
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)8, (boolean)false, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        InetSocketAddress brokerAddress = InetSocketAddress.createUnresolved("127.0.0.1", (Integer)this.pulsar.getBrokerListenPort().get());
        IntStream.range(1, 5).forEach(i -> pool.getConnection(brokerAddress).thenAccept(cnx -> {
            Assert.assertTrue((boolean)cnx.channel().isActive());
            pool.releaseConnection(cnx);
            Assert.assertTrue((boolean)cnx.channel().isActive());
        }));
        Assert.assertEquals((int)pool.getPoolSize(), (int)0);
        pool.closeAllConnections();
        pool.close();
    }

    @Test
    public void testEnableConnectionPool() throws Exception {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setConnectionsPerBroker(5);
        EventLoopGroup eventLoop = EventLoopUtil.newEventLoopGroup((int)8, (boolean)false, (ThreadFactory)new DefaultThreadFactory("test"));
        ConnectionPool pool = (ConnectionPool)Mockito.spy((Object)new ConnectionPool(conf, eventLoop));
        InetSocketAddress brokerAddress = InetSocketAddress.createUnresolved("127.0.0.1", (Integer)this.pulsar.getBrokerListenPort().get());
        IntStream.range(1, 10).forEach(i -> pool.getConnection(brokerAddress).thenAccept(cnx -> {
            Assert.assertTrue((boolean)cnx.channel().isActive());
            pool.releaseConnection(cnx);
            Assert.assertTrue((boolean)cnx.channel().isActive());
        }));
        Assert.assertTrue((pool.getPoolSize() <= 5 && pool.getPoolSize() > 0 ? 1 : 0) != 0);
        pool.closeAllConnections();
        pool.close();
    }
}

