/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.security.Provider;
import java.util.Collections;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.SSLContextValidatorEngine;
import org.testng.annotations.Test;

@Test(groups={"broker-impl"})
public class KeyStoreTlsTest {
    protected final String BROKER_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.keystore.jks";
    protected final String BROKER_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/broker.truststore.jks";
    protected final String BROKER_KEYSTORE_PW = "111111";
    protected final String BROKER_TRUSTSTORE_PW = "111111";
    protected final String CLIENT_KEYSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.keystore.jks";
    protected final String CLIENT_TRUSTSTORE_FILE_PATH = "./src/test/resources/authentication/keystoretls/client.truststore.jks";
    protected final String CLIENT_KEYSTORE_PW = "111111";
    protected final String CLIENT_TRUSTSTORE_PW = "111111";
    protected final String KEYSTORE_TYPE = "JKS";
    public static final Provider BC_PROVIDER = SecurityUtility.getProvider();

    @Test(timeOut=300000L)
    public void testValidate() throws Exception {
        KeyStoreSSLContext serverSSLContext = new KeyStoreSSLContext(KeyStoreSSLContext.Mode.SERVER, null, "JKS", "./src/test/resources/authentication/keystoretls/broker.keystore.jks", "111111", false, "JKS", "./src/test/resources/authentication/keystoretls/broker.truststore.jks", "111111", true, null, null);
        serverSSLContext.createSSLContext();
        KeyStoreSSLContext clientSSLContext = new KeyStoreSSLContext(KeyStoreSSLContext.Mode.CLIENT, null, "JKS", "./src/test/resources/authentication/keystoretls/client.keystore.jks", "111111", false, "JKS", "./src/test/resources/authentication/keystoretls/client.truststore.jks", "111111", false, null, Collections.singleton("TLSv1.2"));
        clientSSLContext.createSSLContext();
        SSLContextValidatorEngine.validate((arg_0, arg_1) -> ((KeyStoreSSLContext)clientSSLContext).createSSLEngine(arg_0, arg_1), (arg_0, arg_1) -> ((KeyStoreSSLContext)serverSSLContext).createSSLEngine(arg_0, arg_1));
    }
}

