/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.RangeEquallyDivideBundleSplitAlgorithm;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RangeEquallyDivideBundleSplitAlgorithmTest {
    @Test
    public void testGetSplitBoundaryMethodReturnCorrectResult() {
        RangeEquallyDivideBundleSplitAlgorithm rangeEquallyDivideBundleSplitAlgorithm = new RangeEquallyDivideBundleSplitAlgorithm();
        Assert.assertThrows(NullPointerException.class, () -> rangeEquallyDivideBundleSplitAlgorithm.getSplitBoundary(null, null));
        long lowerRange = 10L;
        long upperRange = 0xFFFFFFFFL;
        long correctResult = lowerRange + (upperRange - lowerRange) / 2L;
        NamespaceBundle namespaceBundle = new NamespaceBundle(NamespaceName.SYSTEM_NAMESPACE, Range.range((Comparable)Long.valueOf(lowerRange), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(upperRange), (BoundType)BoundType.CLOSED), (NamespaceBundleFactory)Mockito.mock(NamespaceBundleFactory.class));
        CompletableFuture splitBoundary = rangeEquallyDivideBundleSplitAlgorithm.getSplitBoundary(null, namespaceBundle);
        Long value = (Long)splitBoundary.join();
        Assert.assertEquals((long)value, (long)correctResult);
    }
}

