/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.socks5;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.apache.pulsar.socks5.config.Socks5Config;
import org.apache.pulsar.socks5.handler.CommandRequestHandler;
import org.apache.pulsar.socks5.handler.IdleHandler;
import org.apache.pulsar.socks5.handler.InitialRequestHandler;
import org.apache.pulsar.socks5.handler.PasswordAuthRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5Server {
    private static final Logger log = LoggerFactory.getLogger(Socks5Server.class);
    private EventLoopGroup boss = new NioEventLoopGroup();
    private EventLoopGroup worker = new NioEventLoopGroup();
    private final Socks5Config socks5Config;

    public Socks5Server(Socks5Config socks5Config) {
        this.socks5Config = socks5Config;
    }

    public void start() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.boss, this.worker).channel(NioServerSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(90, 90, 0)});
                ch.pipeline().addLast(new ChannelHandler[]{new IdleHandler()});
                ch.pipeline().addLast(new ChannelHandler[]{Socks5ServerEncoder.DEFAULT});
                ch.pipeline().addLast(new ChannelHandler[]{new Socks5InitialRequestDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new InitialRequestHandler(Socks5Server.this.socks5Config)});
                if (Socks5Server.this.socks5Config.isEnableAuth()) {
                    ch.pipeline().addLast(new ChannelHandler[]{new Socks5PasswordAuthRequestDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new PasswordAuthRequestHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new CommandRequestHandler(Socks5Server.this)});
            }
        });
        ChannelFuture future = bootstrap.bind(this.socks5Config.getPort()).sync();
        if (log.isInfoEnabled()) {
            log.info("bind port : {}", (Object)this.socks5Config.getPort());
        }
        future.channel().closeFuture().sync();
    }

    public void shutdown() {
        this.boss.shutdownGracefully();
        this.worker.shutdownGracefully();
    }

    public EventLoopGroup getBoss() {
        return this.boss;
    }
}

