/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.utils.CmdGenerateDocumentation;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"utils"})
public class CmdTest {
    @Test
    public void cmdParserTest() throws Exception {
        this.generateDoc("org.apache.pulsar.broker.ServiceConfiguration");
    }

    @Test
    public void cmdParserWebSocketTest() throws Exception {
        this.generateDoc("org.apache.pulsar.websocket.service.WebSocketProxyConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDoc(String clazz) throws Exception {
        PrintStream oldStream = System.out;
        try (ByteArrayOutputStream baoStream = new ByteArrayOutputStream(2048);
             PrintStream cacheStream = new PrintStream(baoStream);){
            Field[] fields;
            System.setOut(cacheStream);
            CmdGenerateDocumentation.main((String[])("-c " + clazz).split(" "));
            String message = baoStream.toString();
            Class<?> cls = Class.forName(clazz);
            for (Field field : fields = cls.getDeclaredFields()) {
                field.setAccessible(true);
                FieldContext fieldContext = field.getAnnotation(FieldContext.class);
                if (fieldContext == null) continue;
                Assert.assertTrue((message.indexOf(field.getName()) > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            System.setOut(oldStream);
        }
    }
}

