/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.websocket.proxy.SimpleConsumerMessageHandler;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class SimpleConsumerSocket {
    private static final String X_PULSAR_MESSAGE_ID = "messageId";
    private final CountDownLatch closeLatch;
    private Session session;
    private final ArrayList<String> consumerBuffer;
    private final AtomicInteger receivedMessages = new AtomicInteger();
    private SimpleConsumerMessageHandler customMessageHandler;
    private static final Logger log = LoggerFactory.getLogger(SimpleConsumerSocket.class);

    public SimpleConsumerSocket() {
        this.closeLatch = new CountDownLatch(1);
        this.consumerBuffer = new ArrayList();
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    public void setMessageHandler(SimpleConsumerMessageHandler handler) {
        this.customMessageHandler = handler;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        log.info("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
        this.session = null;
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) throws InterruptedException {
        log.info("Got connect: {}", (Object)session);
        this.session = session;
        log.debug("Got connected: {}", (Object)session);
    }

    @OnWebSocketMessage
    public synchronized void onMessage(String msg) throws JsonParseException, IOException {
        this.receivedMessages.incrementAndGet();
        JsonObject message = (JsonObject)new Gson().fromJson(msg, JsonObject.class);
        if (message.get(X_PULSAR_MESSAGE_ID) != null) {
            String messageId = message.get(X_PULSAR_MESSAGE_ID).getAsString();
            this.consumerBuffer.add(messageId);
            if (this.customMessageHandler != null) {
                this.getRemote().sendString(this.customMessageHandler.handle(messageId, message));
            } else {
                JsonObject ack = new JsonObject();
                ack.add(X_PULSAR_MESSAGE_ID, (JsonElement)new JsonPrimitive(messageId));
                this.getRemote().sendString(ack.toString());
            }
        } else {
            this.consumerBuffer.add(message.toString());
        }
    }

    public void sendPermits(int nbPermits) throws IOException {
        JsonObject permitMessage = new JsonObject();
        permitMessage.add("type", (JsonElement)new JsonPrimitive("permit"));
        permitMessage.add("permitMessages", (JsonElement)new JsonPrimitive((Number)nbPermits));
        this.getRemote().sendString(permitMessage.toString());
    }

    public void unsubscribe() throws IOException {
        JsonObject message = new JsonObject();
        message.add("type", (JsonElement)new JsonPrimitive("unsubscribe"));
        this.getRemote().sendString(message.toString());
    }

    public void isEndOfTopic() throws IOException {
        JsonObject message = new JsonObject();
        message.add("type", (JsonElement)new JsonPrimitive("isEndOfTopic"));
        this.getRemote().sendString(message.toString());
    }

    public RemoteEndpoint getRemote() {
        return this.session.getRemote();
    }

    public Session getSession() {
        return this.session;
    }

    public synchronized ArrayList<String> getBuffer() {
        return this.consumerBuffer;
    }

    public int getReceivedMessagesCount() {
        return this.receivedMessages.get();
    }
}

