/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminApiDelayedDelivery
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiDelayedDelivery.class);
    private static final Logger LOG = LoggerFactory.getLogger(AdminApiDelayedDelivery.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("delayed-delivery-messages", (TenantInfo)tenantInfo);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testDisableDelayedDelivery() throws Exception {
        this.admin.namespaces().createNamespace("delayed-delivery-messages/default-ns");
        String namespace = "delayed-delivery-messages/default-ns";
        Assert.assertNull((Object)this.admin.namespaces().getDelayedDelivery(namespace));
        DelayedDeliveryPolicies delayedDeliveryPolicies = DelayedDeliveryPolicies.builder().tickTime(2000L).active(false).build();
        this.admin.namespaces().setDelayedDeliveryMessages(namespace, delayedDeliveryPolicies);
        Awaitility.await().until(() -> this.admin.namespaces().getDelayedDelivery(namespace) != null);
        Assert.assertFalse((boolean)this.admin.namespaces().getDelayedDelivery(namespace).isActive());
        Assert.assertEquals((long)2000L, (long)this.admin.namespaces().getDelayedDelivery(namespace).getTickTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableDelayedDeliveryMessages() throws Exception {
        this.admin.namespaces().createNamespace("delayed-delivery-messages/default-enable-service-conf");
        String namespace = "delayed-delivery-messages/default-enable-service-conf";
        String topicName = "persistent://delayed-delivery-messages/default-enable-service-conf/test";
        Assert.assertNull((Object)this.admin.namespaces().getDelayedDelivery(namespace));
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("test-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topicName).create();
            try {
                int i;
                for (int i2 = 0; i2 < 10; ++i2) {
                    producer.newMessage().value((Object)("delayed-msg-" + i2)).deliverAfter(5L, TimeUnit.SECONDS).sendAsync();
                }
                producer.flush();
                TreeSet<Object> delayedMessages = new TreeSet<Object>();
                for (i = 0; i < 10; ++i) {
                    Message msg = consumer.receive(10, TimeUnit.SECONDS);
                    delayedMessages.add(msg.getValue());
                    consumer.acknowledge(msg);
                }
                for (i = 0; i < 10; ++i) {
                    Assert.assertTrue((boolean)delayedMessages.contains("delayed-msg-" + i));
                }
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    @Test(timeOut=30000L)
    public void testNamespaceDelayedDeliveryPolicyApi() throws Exception {
        String namespace = "delayed-delivery-messages/my-ns";
        this.admin.namespaces().createNamespace("delayed-delivery-messages/my-ns");
        Assert.assertNull((Object)this.admin.namespaces().getDelayedDelivery("delayed-delivery-messages/my-ns"));
        DelayedDeliveryPolicies delayedDeliveryPolicies = DelayedDeliveryPolicies.builder().tickTime(3L).active(true).build();
        this.admin.namespaces().setDelayedDeliveryMessages("delayed-delivery-messages/my-ns", delayedDeliveryPolicies);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((Object)this.admin.namespaces().getDelayedDelivery("delayed-delivery-messages/my-ns"), (Object)delayedDeliveryPolicies));
        this.admin.namespaces().removeDelayedDeliveryMessages("delayed-delivery-messages/my-ns");
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getDelayedDelivery("delayed-delivery-messages/my-ns")));
    }

    @Test(timeOut=30000L)
    public void testDelayedDeliveryApplied() throws Exception {
        this.cleanup();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.setup();
        String namespace = "delayed-delivery-messages/my-ns";
        String topic = "persistent://delayed-delivery-messages/my-ns/test" + UUID.randomUUID();
        this.admin.namespaces().createNamespace("delayed-delivery-messages/my-ns");
        this.pulsarClient.newProducer().topic(topic).create().close();
        Assert.assertNull((Object)this.admin.namespaces().getDelayedDelivery("delayed-delivery-messages/my-ns"));
        Assert.assertNull((Object)this.admin.topics().getDelayedDeliveryPolicy(topic));
        DelayedDeliveryPolicies brokerLevelPolicy = DelayedDeliveryPolicies.builder().tickTime(this.conf.getDelayedDeliveryTickTimeMillis()).active(this.conf.isDelayedDeliveryEnabled()).build();
        Assert.assertEquals((Object)this.admin.topics().getDelayedDeliveryPolicy(topic, true), (Object)brokerLevelPolicy);
        DelayedDeliveryPolicies namespaceLevelPolicy = DelayedDeliveryPolicies.builder().tickTime(100L).active(true).build();
        this.admin.namespaces().setDelayedDeliveryMessages("delayed-delivery-messages/my-ns", namespaceLevelPolicy);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.namespaces().getDelayedDelivery("delayed-delivery-messages/my-ns")));
        DelayedDeliveryPolicies policyFromBroker = this.admin.topics().getDelayedDeliveryPolicy(topic, true);
        Assert.assertEquals((long)policyFromBroker.getTickTime(), (long)100L);
        Assert.assertTrue((boolean)policyFromBroker.isActive());
        DelayedDeliveryPolicies topicLevelPolicy = DelayedDeliveryPolicies.builder().tickTime(200L).active(true).build();
        this.admin.topics().setDelayedDeliveryPolicy(topic, topicLevelPolicy);
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getDelayedDeliveryPolicy(topic)));
        policyFromBroker = this.admin.topics().getDelayedDeliveryPolicy(topic, true);
        Assert.assertEquals((long)policyFromBroker.getTickTime(), (long)200L);
        Assert.assertTrue((boolean)policyFromBroker.isActive());
        this.admin.topics().removeDelayedDeliveryPolicy(topic);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((Object)this.admin.topics().getDelayedDeliveryPolicy(topic, true), (Object)namespaceLevelPolicy));
        this.admin.namespaces().removeDelayedDeliveryMessages("delayed-delivery-messages/my-ns");
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((Object)this.admin.topics().getDelayedDeliveryPolicy(topic, true), (Object)brokerLevelPolicy));
    }
}

