/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiHealthCheckTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiHealthCheckTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.resetConfig();
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("pulsar", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("pulsar/system", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testHealthCheckup() throws Exception {
        this.admin.brokers().healthcheck();
    }

    @Test
    public void testHealthCheckupV1() throws Exception {
        this.admin.brokers().healthcheck(TopicVersion.V1);
    }

    @Test(expectedExceptions={PulsarAdminException.class})
    public void testHealthCheckupV2Error() throws Exception {
        this.admin.brokers().healthcheck(TopicVersion.V2);
    }

    @Test
    public void testHealthCheckupV2() throws Exception {
        URL pulsarWebAddress = new URL(this.pulsar.getWebServiceAddress());
        String targetNameSpace = "pulsar/" + pulsarWebAddress.getHost() + ":" + pulsarWebAddress.getPort();
        log.info("Target namespace for broker admin healthcheck V2 endpoint is {}", (Object)targetNameSpace);
        this.admin.namespaces().createNamespace(targetNameSpace);
        this.admin.brokers().healthcheck(TopicVersion.V2);
    }
}

