/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiMaxUnackedMessages
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiMaxUnackedMessages.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("max-unacked-messages", (TenantInfo)tenantInfo);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.resetConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=30000L)
    public void testNamespacePolicy() throws Exception {
        this.pulsar.getConfiguration().setMaxUnackedMessagesPerConsumer(3);
        this.admin.namespaces().createNamespace("max-unacked-messages/policy-on-consumers");
        String namespace = "max-unacked-messages/policy-on-consumers";
        String topic = "persistent://max-unacked-messages/policy-on-consumers/testNamespacePolicy";
        Producer producer = this.pulsarClient.newProducer().topic("persistent://max-unacked-messages/policy-on-consumers/testNamespacePolicy").create();
        try {
            Consumer consumer = this.pulsarClient.newConsumer().receiverQueueSize(1).subscriptionType(SubscriptionType.Shared).subscriptionName("sub").topic(new String[]{"persistent://max-unacked-messages/policy-on-consumers/testNamespacePolicy"}).subscribe();
            try {
                this.admin.namespaces().setMaxUnackedMessagesPerConsumer("max-unacked-messages/policy-on-consumers", 1);
                PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists("persistent://max-unacked-messages/policy-on-consumers/testNamespacePolicy").get()).get();
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)((org.apache.pulsar.broker.service.Consumer)persistentTopic.getSubscription("sub").getConsumers().get(0)).getMaxUnackedMessages(), (int)1));
                for (int i = 0; i < 20; ++i) {
                    producer.send((Object)"msg".getBytes());
                }
                Message message = consumer.receive(500, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)message);
                Message nullMsg = consumer.receive(500, TimeUnit.MILLISECONDS);
                Assert.assertNull((Object)nullMsg);
                this.admin.namespaces().setMaxUnackedMessagesPerConsumer("max-unacked-messages/policy-on-consumers", 0);
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)((org.apache.pulsar.broker.service.Consumer)persistentTopic.getSubscription("sub").getConsumers().get(0)).getMaxUnackedMessages(), (int)0));
                consumer.acknowledge(message);
                message = consumer.receive(500, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((Object)message);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    @Test
    public void testMaxUnackedMessagesOnConsumers() throws Exception {
        this.admin.namespaces().createNamespace("max-unacked-messages/default-on-consumers");
        String namespace = "max-unacked-messages/default-on-consumers";
        Assert.assertNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerConsumer(namespace));
        this.admin.namespaces().setMaxUnackedMessagesPerConsumer(namespace, 100000);
        Assert.assertEquals((int)100000, (int)this.admin.namespaces().getMaxUnackedMessagesPerConsumer(namespace));
    }

    @Test
    public void testMaxUnackedMessagesOnSubscription() throws Exception {
        this.admin.namespaces().createNamespace("max-unacked-messages/default-on-subscription");
        String namespace = "max-unacked-messages/default-on-subscription";
        Assert.assertNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerSubscription(namespace));
        this.admin.namespaces().setMaxUnackedMessagesPerSubscription(namespace, 400000);
        Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)400000, (int)this.admin.namespaces().getMaxUnackedMessagesPerSubscription(namespace)));
        this.admin.namespaces().removeMaxUnackedMessagesPerSubscription(namespace);
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerSubscription(namespace)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxUnackedMessagesPerConsumerPriority() throws Exception {
        int brokerLevelPolicy = 3;
        int namespaceLevelPolicy = 2;
        int topicLevelPolicy = 1;
        this.cleanup();
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(true);
        this.conf.setMaxUnackedMessagesPerConsumer(brokerLevelPolicy);
        this.setup();
        String namespace = "max-unacked-messages/priority-on-consumers";
        String topic = "persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority";
        this.admin.namespaces().createNamespace("max-unacked-messages/priority-on-consumers");
        Producer producer = this.pulsarClient.newProducer().topic("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority").create();
        try {
            for (int i = 0; i < 50; ++i) {
                producer.send((Object)"msg".getBytes());
            }
            Assert.assertNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers"));
            Assert.assertNull((Object)this.admin.topics().getMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority"));
            this.admin.namespaces().setMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers", namespaceLevelPolicy);
            this.admin.topics().setMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority", topicLevelPolicy);
            Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers")));
            Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.topics().getMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority")));
            Assert.assertEquals((int)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers"), (int)namespaceLevelPolicy);
            Assert.assertEquals((int)this.admin.topics().getMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority"), (int)topicLevelPolicy);
            Consumer consumer = this.pulsarClient.newConsumer().subscriptionType(SubscriptionType.Shared).subscriptionInitialPosition(SubscriptionInitialPosition.Earliest).subscriptionName("sub").topic(new String[]{"persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority"}).receiverQueueSize(1).subscribe();
            try {
                PersistentTopic persistentTopic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopicIfExists("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority").get()).get();
                org.apache.pulsar.broker.service.Consumer serverConsumer = (org.apache.pulsar.broker.service.Consumer)persistentTopic.getSubscription("sub").getConsumers().get(0);
                Assert.assertEquals((int)serverConsumer.getMaxUnackedMessages(), (int)topicLevelPolicy);
                List<Message> msgs = this.consumeMsg(consumer, 3);
                Assert.assertEquals((int)msgs.size(), (int)1);
                this.admin.topics().setMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority", 0);
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.topics().getMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority"), (int)0));
                this.ackMsgs(consumer, msgs);
                this.admin.topics().removeMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority");
                Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.topics().getMaxUnackedMessagesOnConsumer("persistent://max-unacked-messages/priority-on-consumers/testMaxUnackedMessagesPerConsumerPriority")));
                Assert.assertEquals((int)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers"), (int)namespaceLevelPolicy);
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)serverConsumer.getMaxUnackedMessages(), (int)namespaceLevelPolicy));
                msgs = this.consumeMsg(consumer, 5);
                Assert.assertEquals((int)msgs.size(), (int)namespaceLevelPolicy);
                this.ackMsgs(consumer, msgs);
                this.admin.namespaces().setMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers", 0);
                Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers"), (int)0));
                msgs = this.consumeMsg(consumer, 5);
                Assert.assertEquals((int)msgs.size(), (int)5);
                this.ackMsgs(consumer, msgs);
                this.admin.namespaces().removeMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers");
                Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.admin.namespaces().getMaxUnackedMessagesPerConsumer("max-unacked-messages/priority-on-consumers")));
                msgs = this.consumeMsg(consumer, 5);
                Assert.assertEquals((int)msgs.size(), (int)brokerLevelPolicy);
                this.ackMsgs(consumer, msgs);
            }
            finally {
                if (Collections.singletonList(consumer).get(0) != null) {
                    consumer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(producer).get(0) != null) {
                producer.close();
            }
        }
    }

    private List<Message> consumeMsg(Consumer<?> consumer, int msgNum) throws Exception {
        Message message;
        ArrayList<Message> list = new ArrayList<Message>();
        for (int i = 0; i < msgNum && (message = consumer.receive(500, TimeUnit.MILLISECONDS)) != null; ++i) {
            list.add(message);
        }
        return list;
    }

    private void ackMsgs(Consumer<?> consumer, List<Message> msgs) throws Exception {
        for (Message msg : msgs) {
            consumer.acknowledge(msg);
        }
    }
}

