/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.admin.AdminApiTest;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class IncrementPartitionsTest
extends MockedPulsarServiceBaseTest {
    private AdminApiTest.MockedPulsarService mockPulsarSetup;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        super.internalSetup();
        this.mockPulsarSetup = new AdminApiTest.MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
    }

    @Test
    public void testIncrementPartitionsOfTopicOnUnusedTopic() throws Exception {
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/test-topic";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/test-topic", 10);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic").partitions, (int)10);
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic", 20);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic").partitions, (int)20);
    }

    @Test
    public void testIncrementPartitionsOfTopic() throws Exception {
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/test-topic-2";
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 1);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)1);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/test-topic-2"}).subscriptionName("sub-1").subscribe();
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 2);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)2);
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 10);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)10);
        this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/test-topic-2", 20);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/test-topic-2").partitions, (int)20);
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(TopicName.get((String)"persistent://prop-xyz/use/ns1/test-topic-2").getPartition(15).toString()), (Collection)Lists.newArrayList((Object[])new String[]{"sub-1"}));
        consumer.close();
    }

    @Test
    public void testIncrementPartitionsWithNoSubscriptions() throws Exception {
        String partitionedTopicName = BrokerTestUtil.newUniqueName("persistent://prop-xyz/use/ns1/test-topic");
        this.admin.topics().createPartitionedTopic(partitionedTopicName, 1);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)1);
        Producer consumer = this.pulsarClient.newProducer(Schema.STRING).topic(partitionedTopicName).create();
        try {
            this.admin.topics().updatePartitionedTopic(partitionedTopicName, 2);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)2));
            this.admin.topics().updatePartitionedTopic(partitionedTopicName, 10);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)10));
            this.admin.topics().updatePartitionedTopic(partitionedTopicName, 20);
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)20));
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementPartitionsWithReaders() throws Exception {
        TopicName partitionedTopicName = TopicName.get((String)BrokerTestUtil.newUniqueName("persistent://prop-xyz/use/ns1/test-topic"));
        this.admin.topics().createPartitionedTopic(partitionedTopicName.toString(), 1);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName.toString()).partitions, (int)1);
        Producer consumer = this.pulsarClient.newProducer(Schema.STRING).topic(partitionedTopicName.toString()).create();
        try {
            Reader reader = this.pulsarClient.newReader(Schema.STRING).topic(partitionedTopicName.getPartition(0).toString()).startMessageId(MessageId.earliest).create();
            try {
                this.admin.topics().updatePartitionedTopic(partitionedTopicName.toString(), 2);
                Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName.toString()).partitions, (int)2);
                Assert.assertEquals((int)this.admin.topics().getSubscriptions(partitionedTopicName.getPartition(0).toString()).size(), (int)1);
                Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(partitionedTopicName.getPartition(1).toString()), Collections.emptyList());
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

