/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TopicPoliciesDisableTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(TopicPoliciesDisableTest.class);
    private final String testTenant = "my-tenant";
    private final String testNamespace = "my-namespace";
    private final String myNamespace = "my-tenant/my-namespace";
    private final String testTopic = "persistent://my-tenant/my-namespace/test-set-backlog-quota";

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTopicLevelPoliciesEnabled(false);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant(this.testTenant, (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("my-tenant/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.topics().createPartitionedTopic("persistent://my-tenant/my-namespace/test-set-backlog-quota", 2);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testBacklogQuotaDisabled() {
        BacklogQuota backlogQuota = BacklogQuota.builder().limitSize(1024L).retentionPolicy(BacklogQuota.RetentionPolicy.consumer_backlog_eviction).build();
        log.info("Backlog quota: {} will set to the topic: {}", (Object)backlogQuota, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setBacklogQuota("persistent://my-tenant/my-namespace/test-set-backlog-quota", backlogQuota);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().removeBacklogQuota("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getBacklogQuotaMap("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testRetentionDisabled() {
        RetentionPolicies retention = new RetentionPolicies();
        log.info("Retention: {} will set to the topic: {}", (Object)retention, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setRetention("persistent://my-tenant/my-namespace/test-set-backlog-quota", retention);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getRetention("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testPersistenceDisabled() {
        PersistencePolicies persistencePolicies = new PersistencePolicies();
        log.info("PersistencePolicies: {} will set to the topic: {}", (Object)persistencePolicies, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setPersistence("persistent://my-tenant/my-namespace/test-set-backlog-quota", persistencePolicies);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getPersistence("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testDispatchRateDisabled() throws Exception {
        DispatchRate dispatchRate = DispatchRate.builder().build();
        log.info("Dispatch Rate: {} will set to the topic: {}", (Object)dispatchRate, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setDispatchRate("persistent://my-tenant/my-namespace/test-set-backlog-quota", dispatchRate);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getDispatchRate("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testSubscriptionDispatchRateDisabled() throws Exception {
        DispatchRate dispatchRate = DispatchRate.builder().dispatchThrottlingRateInMsg(1000).dispatchThrottlingRateInMsg(1044480).ratePeriodInSecond(1).build();
        log.info("Dispatch Rate: {} will set to the topic: {}", (Object)dispatchRate, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setSubscriptionDispatchRate("persistent://my-tenant/my-namespace/test-set-backlog-quota", dispatchRate);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getSubscriptionDispatchRate("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testCompactionThresholdDisabled() {
        Long compactionThreshold = 10000L;
        log.info("Compaction threshold: {} will set to the topic: {}", (Object)compactionThreshold, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setCompactionThreshold("persistent://my-tenant/my-namespace/test-set-backlog-quota", compactionThreshold.longValue());
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getCompactionThreshold("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testMaxConsumersPerSubscription() throws Exception {
        int maxConsumersPerSubscription = 10;
        log.info("MaxConsumersPerSubscription: {} will set to the topic: {}", (Object)maxConsumersPerSubscription, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setMaxConsumersPerSubscription("persistent://my-tenant/my-namespace/test-set-backlog-quota", maxConsumersPerSubscription);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getMaxConsumersPerSubscription("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().removeMaxConsumersPerSubscription("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testPublishRateDisabled() throws Exception {
        PublishRate publishRate = new PublishRate(10000, 0x500000L);
        log.info("Publish Rate: {} will set to the topic: {}", (Object)publishRate, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setPublishRate("persistent://my-tenant/my-namespace/test-set-backlog-quota", publishRate);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getPublishRate("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testMaxProducersDisabled() {
        log.info("MaxProducers will set to the topic: {}", (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setMaxProducers("persistent://my-tenant/my-namespace/test-set-backlog-quota", 2);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getMaxProducers("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testMaxConsumersDisabled() {
        log.info("MaxConsumers will set to the topic: {}", (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setMaxConsumers("persistent://my-tenant/my-namespace/test-set-backlog-quota", 2);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getMaxConsumers("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }

    @Test
    public void testSubscribeRateDisabled() throws Exception {
        SubscribeRate subscribeRate = new SubscribeRate(10, 30);
        log.info("Subscribe Rate: {} will set to the topic: {}", (Object)subscribeRate, (Object)"persistent://my-tenant/my-namespace/test-set-backlog-quota");
        try {
            this.admin.topics().setSubscribeRate("persistent://my-tenant/my-namespace/test-set-backlog-quota", subscribeRate);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
        try {
            this.admin.topics().getSubscribeRate("persistent://my-tenant/my-namespace/test-set-backlog-quota");
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)405);
        }
    }
}

