/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.packages.management.core.MockedPackagesStorageProvider;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PackagesApiTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setEnablePackagesManagement(true);
        this.conf.setPackagesManagementStorageProvider(MockedPackagesStorageProvider.class.getName());
        super.internalSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(timeOut=60000L)
    public void testPackagesOperations() throws Exception {
        File file = File.createTempFile("package-api-test", ".package");
        String packageName = "function://public/default/test@v1";
        PackageMetadata originalMetadata = PackageMetadata.builder().description("test").build();
        this.admin.packages().upload(originalMetadata, packageName, file.getPath());
        String downloadPath = new File(file.getParentFile(), "package-api-test-download.package").getPath();
        this.admin.packages().download(packageName, downloadPath);
        File downloadFile = new File(downloadPath);
        Assert.assertTrue((boolean)downloadFile.exists());
        downloadFile.delete();
        List packages = this.admin.packages().listPackages("function", "public/default");
        Assert.assertEquals((int)packages.size(), (int)1);
        Assert.assertEquals((String)((String)packages.get(0)), (String)"test");
        List versions = this.admin.packages().listPackageVersions(packageName);
        Assert.assertEquals((int)versions.size(), (int)1);
        Assert.assertEquals((String)((String)versions.get(0)), (String)"v1");
        PackageMetadata metadata = this.admin.packages().getMetadata(packageName);
        Assert.assertEquals((String)metadata.getDescription(), (String)originalMetadata.getDescription());
        Assert.assertNull((Object)metadata.getContact());
        Assert.assertTrue((metadata.getModificationTime() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metadata.getCreateTime() > 0L ? 1 : 0) != 0);
        Assert.assertNull((Object)metadata.getProperties());
        PackageMetadata updatedMetadata = originalMetadata;
        updatedMetadata.setContact("test@apache.org");
        updatedMetadata.setProperties(Collections.singletonMap("key", "value"));
        this.admin.packages().updateMetadata(packageName, updatedMetadata);
        PackageMetadata getUpdatedMetadata = this.admin.packages().getMetadata(packageName);
        Assert.assertEquals((String)getUpdatedMetadata.getDescription(), (String)updatedMetadata.getDescription());
        Assert.assertEquals((String)getUpdatedMetadata.getContact(), (String)updatedMetadata.getContact());
        Assert.assertEquals((Map)getUpdatedMetadata.getProperties(), (Map)updatedMetadata.getProperties());
    }

    @Test(timeOut=60000L)
    public void testPackagesOperationsFailed() {
        List packagesName;
        String unknownPackageName = "function://public/default/unknown@v1";
        try {
            this.admin.packages().download(unknownPackageName, "/test/unknown");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)404, (int)e.getStatusCode());
        }
        try {
            this.admin.packages().getMetadata(unknownPackageName);
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)404, (int)e.getStatusCode());
        }
        try {
            this.admin.packages().updateMetadata(unknownPackageName, PackageMetadata.builder().description("unknown").build());
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)404, (int)e.getStatusCode());
        }
        try {
            packagesName = this.admin.packages().listPackages("function", "unknown/unknown");
            Assert.assertEquals((int)packagesName.size(), (int)0);
        }
        catch (PulsarAdminException e) {
            Assert.fail((String)"should not throw any exception");
        }
        try {
            List versions = this.admin.packages().listPackageVersions(unknownPackageName);
            Assert.assertEquals((int)versions.size(), (int)0);
        }
        catch (PulsarAdminException e) {
            Assert.fail((String)"should not throw any exception");
        }
        try {
            packagesName = this.admin.packages().listPackages("invalid", "unknown/unknown");
            Assert.fail((String)"should throw precondition exception");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)412, (int)e.getStatusCode());
        }
    }
}

