/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.eclipse.jetty.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterBrokerInterceptor
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CounterBrokerInterceptor.class);
    int beforeSendCount = 0;
    int count = 0;
    private List<ResponseEvent> responseList = new ArrayList<ResponseEvent>();

    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
        log.info("Send message to topic {}, subscription {}", (Object)subscription.getTopic(), (Object)subscription.getName());
        ++this.beforeSendCount;
    }

    public void onPulsarCommand(BaseCommand command, ServerCnx cnx) {
        log.info("[{}] On [{}] Pulsar command", (Object)this.count, (Object)command.getType().name());
        ++this.count;
    }

    public void onConnectionClosed(ServerCnx cnx) {
    }

    public void onWebserviceRequest(ServletRequest request) {
        ++this.count;
        log.info("[{}] On [{}] Webservice request", (Object)this.count, (Object)((HttpServletRequest)request).getRequestURL().toString());
    }

    public void onWebserviceResponse(ServletRequest request, ServletResponse response) {
        ++this.count;
        log.info("[{}] On [{}] Webservice response {}", new Object[]{this.count, ((HttpServletRequest)request).getRequestURL().toString(), response});
        if (response instanceof Response) {
            Response res = (Response)response;
            this.responseList.add(new ResponseEvent(res.getHttpChannel().getRequest().getRequestURI(), res.getStatus()));
        }
    }

    public void onFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.count = 100;
        chain.doFilter(request, response);
    }

    public void initialize(PulsarService pulsarService) throws Exception {
    }

    public void close() {
    }

    public int getCount() {
        return this.count;
    }

    public int getBeforeSendCount() {
        return this.beforeSendCount;
    }

    public void clearResponseList() {
        this.responseList.clear();
    }

    public List<ResponseEvent> getResponseList() {
        return this.responseList;
    }

    public class ResponseEvent {
        private String requestUri;
        private int responseStatus;

        public String getRequestUri() {
            return this.requestUri;
        }

        public int getResponseStatus() {
            return this.responseStatus;
        }

        public void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        public void setResponseStatus(int responseStatus) {
            this.responseStatus = responseStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseEvent)) {
                return false;
            }
            ResponseEvent other = (ResponseEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getResponseStatus() != other.getResponseStatus()) {
                return false;
            }
            String this$requestUri = this.getRequestUri();
            String other$requestUri = other.getRequestUri();
            return !(this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getResponseStatus();
            String $requestUri = this.getRequestUri();
            result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
            return result;
        }

        public String toString() {
            return "CounterBrokerInterceptor.ResponseEvent(requestUri=" + this.getRequestUri() + ", responseStatus=" + this.getResponseStatus() + ")";
        }

        public ResponseEvent(String requestUri, int responseStatus) {
            this.requestUri = requestUri;
            this.responseStatus = responseStatus;
        }
    }
}

