/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.CounterBrokerInterceptor;
import org.apache.pulsar.broker.web.PreInterceptFilter;
import org.apache.pulsar.broker.web.ProcessHandlerFilter;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Sets;

@Test(groups={"broker"})
public class InterceptFilterOutTest {
    private static final String[] shouldBeFilterOutContentTypes = new String[]{"multipart/form-data", "Multipart/form-data", "multipart/form-data; boundary=------", "multipart/Form-data; boundary=------", "application/octet-stream", "application/Octet-stream", "application/octet-stream; xxx"};

    @Test
    public void testFilterOutForPreInterceptFilter() throws Exception {
        CounterBrokerInterceptor interceptor = new CounterBrokerInterceptor();
        PreInterceptFilter filter = new PreInterceptFilter((BrokerInterceptor)interceptor);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doNothing().when((Object)chain)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
        MockRequestWrapper mockInputStream = new MockRequestWrapper(request);
        ((HttpServletRequest)Mockito.doReturn((Object)mockInputStream.getInputStream()).when((Object)request)).getInputStream();
        ((HttpServletRequest)Mockito.doReturn((Object)new StringBuffer("http://127.0.0.1:8080")).when((Object)request)).getRequestURL();
        ((HttpServletRequest)Mockito.doReturn((Object)"application/json").when((Object)request)).getContentType();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((int)interceptor.getCount(), (int)1);
        for (String shouldBeFilterOutContentType : shouldBeFilterOutContentTypes) {
            ((HttpServletRequest)Mockito.doReturn((Object)shouldBeFilterOutContentType).when((Object)request)).getContentType();
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            Assert.assertEquals((int)interceptor.getCount(), (int)1);
        }
    }

    @Test
    public void testOnFilter() throws Exception {
        CounterBrokerInterceptor interceptor = new CounterBrokerInterceptor();
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ((PulsarService)Mockito.doReturn((Object)"pulsar://127.0.0.1:6650").when((Object)pulsarService)).getAdvertisedAddress();
        ((PulsarService)Mockito.doReturn((Object)interceptor).when((Object)pulsarService)).getBrokerInterceptor();
        ServiceConfiguration conf = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet((Object[])new String[]{"interceptor"})).when((Object)conf)).getBrokerInterceptors();
        ((PulsarService)Mockito.doReturn((Object)conf).when((Object)pulsarService)).getConfig();
        ProcessHandlerFilter filter = new ProcessHandlerFilter(pulsarService);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doNothing().when((Object)chain)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
        MockRequestWrapper mockInputStream = new MockRequestWrapper(request);
        ((HttpServletRequest)Mockito.doReturn((Object)mockInputStream.getInputStream()).when((Object)request)).getInputStream();
        ((HttpServletRequest)Mockito.doReturn((Object)new StringBuffer("http://127.0.0.1:8080")).when((Object)request)).getRequestURL();
        ((HttpServletRequest)Mockito.doReturn((Object)"application/json").when((Object)request)).getContentType();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((int)interceptor.getCount(), (int)100);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void testFilterOutForResponseInterceptFilter() throws Exception {
        CounterBrokerInterceptor interceptor = new CounterBrokerInterceptor();
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ((PulsarService)Mockito.doReturn((Object)"pulsar://127.0.0.1:6650").when((Object)pulsarService)).getAdvertisedAddress();
        ((PulsarService)Mockito.doReturn((Object)interceptor).when((Object)pulsarService)).getBrokerInterceptor();
        ServiceConfiguration conf = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet((Object[])new String[]{"interceptor"})).when((Object)conf)).getBrokerInterceptors();
        ((PulsarService)Mockito.doReturn((Object)conf).when((Object)pulsarService)).getConfig();
        ResponseHandlerFilter filter = new ResponseHandlerFilter(pulsarService);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doNothing().when((Object)chain)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
        MockRequestWrapper mockInputStream = new MockRequestWrapper(request);
        ((HttpServletRequest)Mockito.doReturn((Object)mockInputStream.getInputStream()).when((Object)request)).getInputStream();
        ((HttpServletRequest)Mockito.doReturn((Object)new StringBuffer("http://127.0.0.1:8080")).when((Object)request)).getRequestURL();
        ((HttpServletRequest)Mockito.doReturn((Object)"application/json").when((Object)request)).getContentType();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((int)interceptor.getCount(), (int)1);
        for (String shouldBeFilterOutContentType : shouldBeFilterOutContentTypes) {
            ((HttpServletRequest)Mockito.doReturn((Object)shouldBeFilterOutContentType).when((Object)request)).getContentType();
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            Assert.assertEquals((int)interceptor.getCount(), (int)1);
        }
    }

    @Test
    public void testShouldNotInterceptWhenInterceptorDisabled() throws Exception {
        CounterBrokerInterceptor interceptor = new CounterBrokerInterceptor();
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ((PulsarService)Mockito.doReturn((Object)"pulsar://127.0.0.1:6650").when((Object)pulsarService)).getAdvertisedAddress();
        ((PulsarService)Mockito.doReturn((Object)interceptor).when((Object)pulsarService)).getBrokerInterceptor();
        ServiceConfiguration conf = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((ServiceConfiguration)Mockito.doReturn((Object)Sets.newHashSet()).when((Object)conf)).getBrokerInterceptors();
        ((PulsarService)Mockito.doReturn((Object)conf).when((Object)pulsarService)).getConfig();
        ResponseHandlerFilter filter = new ResponseHandlerFilter(pulsarService);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doNothing().when((Object)chain)).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
        MockRequestWrapper mockInputStream = new MockRequestWrapper(request);
        ((HttpServletRequest)Mockito.doReturn((Object)mockInputStream.getInputStream()).when((Object)request)).getInputStream();
        ((HttpServletRequest)Mockito.doReturn((Object)new StringBuffer("http://127.0.0.1:8080")).when((Object)request)).getRequestURL();
        ((HttpServletRequest)Mockito.doReturn((Object)"application/json").when((Object)request)).getContentType();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((int)interceptor.getCount(), (int)0);
    }

    private static class MockRequestWrapper
    extends HttpServletRequestWrapper {
        private final byte[] body = new byte[]{0, 1, 2, 3, 4, 5};

        public MockRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public ServletInputStream getInputStream() {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            return new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() {
                    return byteArrayInputStream.read();
                }
            };
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), Charset.defaultCharset()));
        }
    }
}

