/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ProtocolHandlerWithClassLoaderTest {
    @Test
    public void testWrapper() throws Exception {
        ProtocolHandler h = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        NarClassLoader loader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        ProtocolHandlerWithClassLoader wrapper = new ProtocolHandlerWithClassLoader(h, loader);
        String protocol = "kafka";
        Mockito.when((Object)h.protocolName()).thenReturn((Object)protocol);
        Assert.assertEquals((String)protocol, (String)wrapper.protocolName());
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).protocolName();
        Mockito.when((Object)h.accept((String)ArgumentMatchers.eq((Object)protocol))).thenReturn((Object)true);
        Assert.assertTrue((boolean)wrapper.accept(protocol));
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).accept((String)ArgumentMatchers.same((Object)protocol));
        ServiceConfiguration conf = new ServiceConfiguration();
        wrapper.initialize(conf);
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).initialize((ServiceConfiguration)ArgumentMatchers.same((Object)conf));
        BrokerService service = (BrokerService)Mockito.mock(BrokerService.class);
        wrapper.start(service);
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).start(service);
        String protocolData = "test-protocol-data";
        Mockito.when((Object)h.getProtocolDataToAdvertise()).thenReturn((Object)protocolData);
        Assert.assertEquals((String)protocolData, (String)wrapper.getProtocolDataToAdvertise());
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).getProtocolDataToAdvertise();
    }

    public void testClassLoaderSwitcher() throws Exception {
        final NarClassLoader loader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        final String protocol = "test-protocol";
        ProtocolHandler h = new ProtocolHandler(){

            public String protocolName() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
                return protocol;
            }

            public boolean accept(String protocol2) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
                return true;
            }

            public void initialize(ServiceConfiguration conf) throws Exception {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
                throw new Exception("test exception");
            }

            public String getProtocolDataToAdvertise() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
                return "test-protocol-data";
            }

            public void start(BrokerService service) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
            }

            public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
                return null;
            }

            public void close() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loader);
            }
        };
        ProtocolHandlerWithClassLoader wrapper = new ProtocolHandlerWithClassLoader(h, loader);
        ClassLoader curClassLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertEquals((String)wrapper.protocolName(), (String)protocol);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        Assert.assertTrue((boolean)wrapper.accept(protocol));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        ServiceConfiguration conf = new ServiceConfiguration();
        Assert.expectThrows(Exception.class, () -> wrapper.initialize(conf));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        Assert.assertEquals((String)wrapper.getProtocolDataToAdvertise(), (String)"test-protocol-data");
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        BrokerService service = (BrokerService)Mockito.mock(BrokerService.class);
        wrapper.start(service);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        Assert.assertNull((Object)wrapper.newChannelInitializers());
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        wrapper.close();
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
    }
}

